/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.util;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFenceGate;
import net.minecraft.core.block.BlockLogicStairs;
import net.minecraft.core.block.BlockLogicTorch;
import net.minecraft.core.block.BlockLogicTrapDoor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import teamport.aether.helper.MetadataHelper;
import teamport.aether.helper.Pair;
import teamport.aether.helper.unboxed.IntPair;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class WorldFeatureBlock
extends WorldFeaturePoint {
    private static final byte MASK_DIRECTION = 3;
    private static final byte MASK_DIRECTION_FULL = 7;
    private int blockId;
    private int metadata;
    private boolean withNotify;

    WorldFeatureBlock(int x, int y, int z, int blockId, int metadata, boolean withNotify) {
        super(x, y, z);
        this.blockId = blockId;
        this.metadata = metadata;
        this.withNotify = withNotify;
    }

    WorldFeatureBlock(int x, int y, int z, Pair<Integer, Integer> blockAndMeta, boolean withNotify) {
        super(x, y, z);
        this.blockId = blockAndMeta.getFirst();
        this.metadata = blockAndMeta.getSecond();
        this.withNotify = withNotify;
    }

    WorldFeatureBlock(int x, int y, int z, IntPair blockAndMeta, boolean withNotify) {
        super(x, y, z);
        this.blockId = blockAndMeta.getFirst();
        this.metadata = blockAndMeta.getSecond();
        this.withNotify = withNotify;
    }

    public static WorldFeatureBlock wfb(WorldFeaturePoint point, int blockID, int metadata, boolean withNotify) {
        return new WorldFeatureBlock(point.getX(), point.getY(), point.getZ(), blockID, metadata, withNotify);
    }

    public static WorldFeatureBlock wfb(WorldFeaturePoint point, int blockID, int metadata) {
        return new WorldFeatureBlock(point.getX(), point.getY(), point.getZ(), blockID, metadata, false);
    }

    public static WorldFeatureBlock wfb(WorldFeaturePoint point) {
        return new WorldFeatureBlock(point.getX(), point.getY(), point.getZ(), 0, 0, false);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z) {
        return new WorldFeatureBlock(x, y, z, 0, 0, false);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, int blockID) {
        return new WorldFeatureBlock(x, y, z, blockID, 0, false);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, int blockID, int metadata) {
        return new WorldFeatureBlock(x, y, z, blockID, metadata, false);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, int blockID, boolean withNotify) {
        return new WorldFeatureBlock(x, y, z, blockID, 0, withNotify);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, int blockID, int metadata, boolean withNotify) {
        return new WorldFeatureBlock(x, y, z, blockID, metadata, withNotify);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, IntPair blockAndMeta, boolean withNotify) {
        return new WorldFeatureBlock(x, y, z, blockAndMeta, withNotify);
    }

    public static WorldFeatureBlock wfb(int x, int y, int z, Pair<Integer, Integer> blockAndMeta, boolean withNotify) {
        return new WorldFeatureBlock(x, y, z, blockAndMeta, withNotify);
    }

    public void place(World world) {
        this.place(world, this.getX(), this.getY(), this.getZ());
    }

    private void place(World world, int ix, int iy, int iz) {
        if (this.withNotify) {
            world.setBlockAndMetadataWithNotify(ix, iy, iz, this.blockId, this.metadata);
        } else {
            world.setBlockAndMetadata(ix, iy, iz, this.blockId, this.metadata);
        }
    }

    @Override
    public WorldFeaturePoint rotateYAroundPivot(WorldFeaturePoint pivotPoint, Direction direction) {
        Direction newDirection;
        Direction currentDirection;
        int indexDirection;
        super.rotateYAroundPivot(pivotPoint, direction);
        int rotateAmount = direction.getHorizontalIndex() - Direction.NORTH.getHorizontalIndex();
        Block block = Blocks.getBlock((int)this.blockId);
        if (block == null) {
            return this;
        }
        BlockLogic logic = block.getLogic();
        if (logic == null) {
            return this;
        }
        if (logic instanceof BlockLogicFenceGate) {
            indexDirection = this.metadata & 3;
            if (indexDirection > Direction.horizontalDirections.length) {
                indexDirection = 0;
            }
            currentDirection = Direction.horizontalDirections[indexDirection];
            newDirection = currentDirection.rotate(rotateAmount);
            this.metadata = MetadataHelper.maskDirectionHorizontal(this.metadata, newDirection);
        }
        if (logic instanceof BlockLogicStairs) {
            indexDirection = this.metadata & 3;
            currentDirection = MetadataHelper.getStairDirectionFromMetadata(indexDirection);
            newDirection = currentDirection.rotate(rotateAmount);
            this.metadata = MetadataHelper.maskDirectionHorizontal(this.metadata, MetadataHelper.getStairMetadataFromDirection(newDirection));
        }
        if (logic instanceof BlockLogicTorch) {
            indexDirection = this.metadata & 7;
            currentDirection = MetadataHelper.getTorchDirectionFromMetadata(indexDirection);
            newDirection = currentDirection.rotate(rotateAmount);
            this.metadata = MetadataHelper.maskDirectionHorizontal(this.metadata, MetadataHelper.getTorchMetadataFromDirection(newDirection));
        }
        if (logic instanceof BlockLogicTrapDoor) {
            indexDirection = this.metadata & 3;
            currentDirection = MetadataHelper.getTrapDoorDirectionForMeta(indexDirection);
            newDirection = currentDirection.rotate(rotateAmount);
            this.metadata = MetadataHelper.maskDirectionHorizontal(this.metadata, MetadataHelper.getTrapDoorMetaForDirection(newDirection));
        }
        return this;
    }

    @Override
    public WorldFeatureBlock rotateYAroundPivot(int pivotX, int pivotY, int pivotZ, float angle) {
        super.rotateYAroundPivot(pivotX, pivotY, pivotZ, angle);
        return this;
    }

    @Override
    public CompoundTag toCompoundTag() {
        CompoundTag tag = super.toCompoundTag();
        tag.putInt("blockID", this.blockId);
        tag.putInt("blockMetadata", this.metadata);
        tag.putBoolean("withNotify", this.withNotify);
        return tag;
    }

    public static WorldFeatureBlock fromCompoundTag(CompoundTag tag) {
        return WorldFeatureBlock.wfb(WorldFeaturePoint.fromCompoundTag(tag), tag.getInteger("blockID"), tag.getInteger("blockMetadata"), tag.getBoolean("withNotify"));
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public void setMetadata(int metadata) {
        this.metadata = metadata;
    }

    public boolean isWithNotify() {
        return this.withNotify;
    }

    public void setWithNotify(boolean withNotify) {
        this.withNotify = withNotify;
    }
}

