/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.type;

import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import net.minecraft.core.world.wind.WindProvider;
import net.minecraft.core.world.wind.WindProviderGeneric;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.chunk.BiomeProviderAether;
import teamport.aether.world.chunk.ChunkGeneratorAether;

public class WorldTypeAether
extends WorldType {
    public WorldTypeAether(WorldType.Properties properties) {
        super(properties);
    }

    public static WorldType.Properties defaultProperties(String translationKey) {
        return WorldType.Properties.of((String)translationKey).brightnessRamp(WorldTypeAether.getLightRamp()).defaultWeather(Weathers.OVERWORLD_CLEAR).windManager((WindProvider)new WindProviderGeneric()).seasonConfig(SeasonConfig.builder().withSeasonInCycle(Seasons.OVERWORLD_SPRING, 14).withSeasonInCycle(Seasons.OVERWORLD_SUMMER, 14).withSeasonInCycle(Seasons.OVERWORLD_FALL, 14).withSeasonInCycle(Seasons.OVERWORLD_WINTER, 14).build()).dayNightCycleTicks(24000).oceanBlock(null).fillerBlock(AetherBlocks.COBBLE_HOLYSTONE);
    }

    public static float[] getLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    public int getOceanY() {
        return 0;
    }

    public int getOceanBlockId() {
        return 0;
    }

    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderAether(world.getRandomSeed(), this);
    }

    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorAether(world);
    }

    public boolean isValidSpawn(World world, int i, int j, int k) {
        return world.getBlock(i, j, k) == AetherBlocks.GRASS_AETHER;
    }

    public float getTimeOfDay(World world, long tick, float partialTick) {
        if (!AetherDimension.isSunspiritDead()) {
            return 0.0f;
        }
        float timeFraction = WorldTypeAether.getTimeFraction(tick, partialTick);
        long currTime = world.getWorldTime();
        if (AetherDimension.getSunspiritDeathTimestamp() != 0L && AetherDimension.getSunspiritDeathTimestamp() + 250L >= currTime) {
            float animProgress = ((float)currTime + partialTick - (float)AetherDimension.getSunspiritDeathTimestamp()) / 250.0f;
            if (animProgress == 1.0f) {
                AetherDimension.setSunspiritDeathTimestamp(0L);
            }
            return (float)(-(Math.cos(Math.PI * (double)animProgress) - 1.0) / 2.0) * (timeFraction + 1.0f) % 1.0f;
        }
        return timeFraction;
    }

    private static float getTimeFraction(long tick, float partialTick) {
        int timeTicks = (int)(tick % 80000L);
        float timeFraction = ((float)timeTicks + partialTick) / 120000.0f - 0.25f;
        if (timeTicks > 60000) {
            timeFraction = ((float)(timeTicks -= 40000) + partialTick) / 20000.0f - 0.25f;
        }
        if (timeFraction < 0.0f) {
            timeFraction += 1.0f;
        }
        if (timeFraction > 1.0f) {
            timeFraction -= 1.0f;
        }
        float f2 = timeFraction;
        timeFraction = 1.0f - (float)((Math.cos((double)timeFraction * Math.PI) + 1.0) / 2.0);
        timeFraction = f2 + (timeFraction - f2) / 3.0f;
        return timeFraction;
    }

    public float getCelestialAngle(World world, long tick, float partialTick) {
        return this.getTimeOfDay(world, tick, partialTick);
    }

    public int getSkyDarken(World world, long tick, float partialTick) {
        float f1 = this.getCelestialAngle(world, tick, partialTick);
        float f2 = 1.0f - (MathHelper.cos((float)(f1 * 3.141593f * 2.0f)) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float weatherOffset = 0.0f;
        Weather currentWeather = world.getCurrentWeather();
        if (currentWeather != null) {
            weatherOffset = (float)currentWeather.subtractLightLevel * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower();
        }
        return (int)(f2 * (11.0f - weatherOffset) + weatherOffset);
    }
}

