/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.block.dungeon;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jspecify.annotations.Nullable;
import teamport.aether.helper.ParticleMaker;

public class BlockLogicDungeonDoor
extends BlockLogicRotatable {
    public final @Nullable Supplier<Item> droppedItem;

    public BlockLogicDungeonDoor(Block<?> block, @Nullable Supplier<Item> droppedItem) {
        super(block, Material.stone);
        this.droppedItem = droppedItem;
    }

    public boolean getImmovable() {
        return true;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (this.droppedItem == null) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this.droppedItem.get())};
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        int destY;
        Direction dir = BlockLogicDungeonDoor.getDirectionFromMeta((int)world.getBlockMetadata(x, y, z));
        if (dir.getSide() != side) {
            return false;
        }
        Direction dirOpposite = dir.getOpposite();
        int destX = x + dirOpposite.getOffsetX();
        int destZ = z + dirOpposite.getOffsetZ();
        for (destY = y + dirOpposite.getOffsetY(); destY > 0 && world.getBlockId(destX, destY - 1, destZ) == 0; --destY) {
        }
        if (world.isBlockNormalCube(destX, destY, destZ) || world.isBlockNormalCube(destX, destY + 1, destZ)) {
            return false;
        }
        player.moveTo((double)destX + 0.5, (double)destY, (double)destZ + 0.5, player.yRot, player.xRot);
        world.playSoundEffect(null, SoundCategory.ENTITY_SOUNDS, (double)destX, (double)destY, (double)destZ, "random.door_open", 0.5f, 0.5f);
        return true;
    }

    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        return this.getBoundsForRotation(BlockLogicRotatable.getDirectionFromMeta((int)world.getBlockMetadata(x, y, z)));
    }

    public AABB getBoundsForRotation(Direction rotation) {
        float top = 1.0f;
        float bottom = 0.0f;
        float thickness = 0.25f;
        switch (rotation) {
            case EAST: 
            case WEST: {
                return AABB.getTemporaryBB((double)thickness, (double)bottom, (double)0.0, (double)(1.0f - thickness), (double)top, (double)1.0);
            }
        }
        return AABB.getTemporaryBB((double)0.0, (double)bottom, (double)thickness, (double)1.0, (double)top, (double)(1.0f - thickness));
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        this.removeDoorGrid(world, x, y, z, data);
    }

    private void removeDoorGrid(World world, int x, int y, int z, int meta) {
        world.noNeighborUpdate = true;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    int checkZ;
                    int checkY;
                    int checkX;
                    if (dx == 0 && dy == 0 && dz == 0 || world.getBlockId(checkX = x + dx, checkY = y + dy, checkZ = z + dz) != this.block.id() || world.getBlockMetadata(checkX, checkY, checkZ) != meta) continue;
                    world.setBlockWithNotify(checkX, checkY, checkZ, 0);
                    ParticleMaker.spawnBlockBreakParticles(world, checkX, checkY, checkZ, this.id());
                }
            }
        }
        world.noNeighborUpdate = false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }
}

