/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.block.dungeon;

import java.util.Random;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.block.dungeon.BlockLogicDungeon;
import teamport.aether.entity.monster.sentry.MobSentry;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicTrapped
extends BlockLogicDungeon {
    public final Class<? extends Entity> monster;
    private final Block<?> breakResult;
    private final Block<?> replaceOnClear;
    private final int cooldown;

    public BlockLogicTrapped(Block<?> block, Block<?> breakResult, Block<?> replaceOnClear, Class<? extends Entity> monster, int cooldown) {
        super(block, Material.stone);
        block.setTicking(true);
        this.monster = monster;
        this.breakResult = breakResult;
        this.replaceOnClear = replaceOnClear;
        this.cooldown = cooldown;
    }

    public @Nullable ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return this.breakResult.getBreakResult(world, dropCause, meta, tileEntity);
    }

    public int tickDelay() {
        return this.cooldown;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (!world.isClientSide && world.getBlockMetadata(x, y, z) != 1) {
            world.setBlockMetadata(x, y, z, 0);
        }
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (EnvironmentHelper.isClientWorld() || !(entity instanceof Player) || !world.getDifficulty().canHostileMobsSpawn() || world.getBlockMetadata(x, y, z) != 0) {
            return;
        }
        this.triggerTrap(world, x, y, z, entity);
    }

    private void triggerTrap(World world, int x, int y, int z, Entity entity) {
        Entity theMonster = EntityDispatcher.createEntityInWorld(this.monster, (World)world);
        if (theMonster == null) {
            return;
        }
        theMonster.spawnInit();
        int tries = 16;
        while (tries-- > 0) {
            double angleRad = Math.toRadians(world.rand.nextInt(360));
            float distance = (float)(2 + world.rand.nextInt(2)) - (float)world.rand.nextInt(11) / 10.0f;
            double spawnX = (double)x + 0.5 + (double)distance * Math.cos(angleRad);
            double spawnZ = (double)z + 0.5 + (double)distance * Math.sin(angleRad);
            double spawnY = (double)y + 1.25;
            theMonster.moveTo(spawnX, (double)y + 1.0, spawnZ, 0.0f, 0.0f);
            if (!world.checkIfAABBIsClear(theMonster.bb) && !world.getCubes(theMonster, theMonster.bb).isEmpty()) continue;
            world.entityJoinedWorld(theMonster);
            world.setBlockMetadata(x, y, z, 1);
            world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
            this.spawnParticles(world, spawnX, spawnY, spawnZ);
            this.playSound(world, x, y, z, entity, theMonster);
            this.giveAchievement((Player)entity, theMonster);
            return;
        }
    }

    public Block<?> getReplaceOnClear() {
        return this.replaceOnClear;
    }

    public Block<?> getBreakResult() {
        return this.breakResult;
    }

    private void giveAchievement(Player player, Entity theMonster) {
        if (theMonster instanceof MobSentry) {
            player.triggerAchievement((Stat)AetherAchievements.SENTRY_DEPLOYED);
        }
    }

    private void playSound(World world, int x, int y, int z, Entity entity, Entity theMonster) {
        world.playSoundEffect(entity, SoundCategory.ENTITY_SOUNDS, (double)x, (double)y, (double)z, "mob.ghast.fireball", 1.0f, 1.0f);
        world.playSoundAtEntity(entity, theMonster, "mob.ghast.fireball", 0.25f, 0.75f);
    }

    private void spawnParticles(World world, double x, double y, double z) {
        for (int l = 0; l < 8; ++l) {
            double angle = Math.toRadians((double)l * 45.0);
            ParticleMaker.spawnParticle(world, "snowshovel", x, y, z, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
            ParticleMaker.spawnParticle(world, "snowshovel", x, y, z, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
            ParticleMaker.spawnParticle(world, "largesmoke", x, y, z, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
        }
    }
}

