/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.world.World;
import teamport.aether.AetherRecipes;
import teamport.aether.block.AetherBlocks;
import teamport.aether.block.entity.AetherTileEntityMachine;
import teamport.aether.block.machine.BlockLogicFreezer;
import teamport.aether.item.AetherItems;
import teamport.aether.lookup.LookupFuelFreezer;

public class TileEntityFreezer
extends AetherTileEntityMachine {
    private static final Map<Integer, Integer> buckets = new HashMap<Integer, Integer>();

    @Override
    public String getNameTranslationKey() {
        return "container.freezer.name";
    }

    @Override
    public void tick() {
        boolean isEnergyTimeHigherThan0 = this.getCurrentEnergyTime() > 0;
        boolean updateMachine = false;
        if (this.getCurrentEnergyTime() > 0) {
            this.setCurrentEnergyTime(this.getCurrentEnergyTime() - 1);
        }
        if (this.canProcess()) {
            this.setMaxProcessTime((Integer)AetherRecipes.FREEZER.findRecipe(this.containerItemStacks[0]).getData());
        }
        if (this.isUpdateMachine(updateMachine, isEnergyTimeHigherThan0)) {
            this.setChanged();
        }
    }

    public boolean isUpdateMachine(boolean updateMachine, boolean isEnergyTimeHigherThan0) {
        if (this.worldObj == null || !this.worldObj.isClientSide) {
            updateMachine = this.eternallyLit(updateMachine);
            if (this.getCurrentEnergyTime() == 0 && this.containerItemStacks[1] != null && this.canProcess()) {
                this.setCurrentEnergyTime(this.getEnergyTimeFromItem(this.containerItemStacks[1]));
                this.setMaxEnergyTime(this.getCurrentEnergyTime());
                if (this.getCurrentEnergyTime() > 0) {
                    updateMachine = true;
                    if (this.containerItemStacks[1] != null) {
                        --this.containerItemStacks[1].stackSize;
                        if (this.containerItemStacks[1].stackSize <= 0) {
                            this.containerItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isProcessing() && this.canProcess()) {
                this.setCurrentProcessTime(this.getCurrentProcessTime() + 1);
                if (this.getCurrentProcessTime() >= this.getMaxProcessTime()) {
                    this.setCurrentProcessTime(0);
                    this.processItem();
                    updateMachine = true;
                }
            } else {
                this.setCurrentProcessTime(0);
            }
            if (isEnergyTimeHigherThan0 != this.getCurrentEnergyTime() > 0) {
                this.updateContainer(false);
                updateMachine = true;
            }
        }
        return updateMachine;
    }

    public boolean eternallyLit(boolean updateMachine) {
        if ((this.worldObj == null || this.worldObj.getBlockId(this.x, this.y, this.z) == AetherBlocks.FREEZER_IDLE.id()) && this.getCurrentEnergyTime() == 0 && this.containerItemStacks[0] == null && this.containerItemStacks[1] != null && this.containerItemStacks[1].itemID == AetherItems.ARMOR_TALISMAN_ICE.id) {
            this.updateContainer(true);
            return true;
        }
        return updateMachine;
    }

    @Override
    public boolean canProcess() {
        if (this.containerItemStacks[0] == null) {
            return false;
        }
        ItemStack toProcess = this.containerItemStacks[0];
        ItemStack resultStack = AetherRecipes.FREEZER.findOutput(toProcess);
        if (resultStack == null) {
            return false;
        }
        ItemStack resultItem = this.containerItemStacks[2];
        if (resultItem == null) {
            return true;
        }
        if (!resultItem.isItemEqual(resultStack)) {
            return false;
        }
        if (resultItem.stackSize < this.getMaxStackSize() && resultItem.stackSize < resultItem.getMaxStackSize()) {
            return true;
        }
        return resultItem.stackSize < resultStack.getMaxStackSize();
    }

    @Override
    public void processItem() {
        boolean wasEmpty;
        if (!this.canProcess()) {
            return;
        }
        ItemStack processedItem = AetherRecipes.FREEZER.findOutput(this.containerItemStacks[0]);
        if (processedItem != null && processedItem.isItemStackDamageable()) {
            processedItem.setCustomName(this.containerItemStacks[0].getCustomName());
            processedItem.setCustomColor(this.containerItemStacks[0].getCustomColor());
        }
        boolean bl = wasEmpty = this.containerItemStacks[2] == null;
        if (this.containerItemStacks[2] == null && processedItem != null) {
            if (this.containerItemStacks[0] != null && this.containerItemStacks[0].isItemStackDamageable() && processedItem.isItemStackDamageable()) {
                processedItem.setMetadata(this.containerItemStacks[0].getMetadata());
            }
            this.containerItemStacks[2] = processedItem.copy();
        } else if (this.containerItemStacks[2] != null && processedItem != null && this.containerItemStacks[2].itemID == processedItem.itemID) {
            ItemStack resultItem = this.containerItemStacks[2];
            resultItem.stackSize += processedItem.stackSize;
        }
        if (this.isBucket(this.containerItemStacks[0])) {
            this.containerItemStacks[0] = this.getBucket(this.containerItemStacks[0]);
        } else {
            --this.containerItemStacks[0].stackSize;
            if (this.containerItemStacks[0].stackSize <= 0) {
                this.containerItemStacks[0] = null;
            }
        }
        if (this.worldObj != null && wasEmpty && this.containerItemStacks[2] != null) {
            this.worldObj.markBlockNeedsUpdate(this.x, this.y, this.z);
        }
    }

    public boolean isBucket(ItemStack itemStack) {
        for (Integer id : buckets.keySet()) {
            if (itemStack.getItem().id != id) continue;
            return true;
        }
        return false;
    }

    public ItemStack getBucket(ItemStack stack) {
        int id = buckets.get(stack.getItem().id);
        Item item = Item.getItem((int)id);
        return new ItemStack(Objects.requireNonNull(item), 1);
    }

    @Override
    public void updateContainer(boolean forceLit) {
        if (this.worldObj != null) {
            BlockLogicFreezer.updateFurnaceBlockState(forceLit || this.getCurrentEnergyTime() > 0, this.worldObj, this.x, this.y, this.z);
            return;
        }
        if (this.carriedBlock != null) {
            this.carriedBlock.blockId = forceLit || this.getCurrentEnergyTime() > 0 ? AetherBlocks.FREEZER_ACTIVE.id() : AetherBlocks.FREEZER_IDLE.id();
        }
    }

    @Override
    public int getEnergyTimeFromItem(ItemStack itemStack) {
        return itemStack == null ? 0 : LookupFuelFreezer.INSTANCE.getFuelYield(itemStack.getItem().id);
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        if (!BlockLogicFreezer.isKeepFreezerInventory()) {
            for (int l = 0; l < this.getContainerSize(); ++l) {
                ItemStack itemstack = this.getItem(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityItem.xd = (float)this.random.nextGaussian() * f3;
                    entityItem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityItem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld((Entity)entityItem);
                }
            }
        }
    }

    @Override
    public Packet getDescriptionPacket() {
        return this.containerItemStacks[2] != null ? new PacketTileEntityData((TileEntity)this) : null;
    }

    static {
        buckets.put(Items.BUCKET_WATER.id, Items.BUCKET.id);
        buckets.put(Items.BUCKET_LAVA.id, Items.BUCKET.id);
        buckets.put(AetherItems.BUCKET_SKYROOT_WATER.id, AetherItems.BUCKET_SKYROOT.id);
    }
}

