/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.block.skyroot;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicPressurePlate;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import teamport.aether.block.skyroot.BlockLogicPaintedPressurePlate;

public class BlockLogicPaintablePressurePlate<T extends Entity>
extends BlockLogicPressurePlate<T> {
    protected final Block<? extends BlockLogicPaintedPressurePlate<T>> paintedBlock;

    public BlockLogicPaintablePressurePlate(Block<?> block, Class<T> mobType, Material material, Block<? extends BlockLogicPaintedPressurePlate<T>> paintedBlock) {
        super(block, mobType, material);
        this.paintedBlock = paintedBlock;
    }

    public int tickDelay() {
        return 10;
    }

    public boolean canBePainted() {
        return true;
    }

    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadataRaw(x, y, z, this.paintedBlock.id(), meta);
        world.setBlockMetadata(x, y, z, meta);
        ((BlockLogicPaintedPressurePlate)this.paintedBlock.getLogic()).setColor(world, x, y, z, color);
        if (BlockLogicPaintablePressurePlate.isPressed((int)meta)) {
            world.scheduleBlockUpdate(x, y, z, this.paintedBlock.id(), this.tickDelay());
        }
    }
}

