/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.block.terrain;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;

public class BlockLogicIceStone
extends BlockLogic {
    private static final Map<Integer, Integer> freezeResultNatural = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> freezeResultOnPlace = new HashMap<Integer, Integer>();

    public BlockLogicIceStone(Block<?> block) {
        super(block, Material.stone);
    }

    public int tickDelay() {
        return 50;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.attemptFreeze(false, world, x, y, z);
        super.updateTick(world, x, y, z, rand);
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NonNull Side side, Mob mob, double xPlaced, double yPlaced) {
        this.attemptFreeze(true, world, x, y, z);
        this.attemptFreeze(true, world, x, y, z);
        this.attemptFreeze(true, world, x, y, z);
        this.attemptFreeze(true, world, x, y, z);
        this.attemptFreeze(true, world, x, y, z);
        super.onBlockPlacedByMob(world, x, y, z, side, mob, xPlaced, yPlaced);
    }

    public void attemptFreeze(boolean onPlace, World world, int x, int y, int z) {
        int l = 0;
        while (l < 32) {
            int x1 = x + world.rand.nextInt(8) - world.rand.nextInt(8);
            int y1 = y + world.rand.nextInt(4) - world.rand.nextInt(4);
            int z1 = z + world.rand.nextInt(8) - world.rand.nextInt(8);
            int radius = 4;
            if (Math.pow(x1 - x, 2.0) + Math.pow(y1 - y, 2.0) + Math.pow(z1 - z, 2.0) > Math.pow(radius, 2.0)) continue;
            this.freezeBlock(onPlace, world, x1, y1, z1);
            ++l;
        }
    }

    public void freezeBlock(boolean onPlace, World world, int x, int y, int z) {
        int block = world.getBlockId(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if ((block == Blocks.FLUID_WATER_STILL.id() || block == Blocks.FLUID_LAVA_STILL.id() || block == Blocks.FLUID_WATER_FLOWING.id() || block == Blocks.FLUID_LAVA_FLOWING.id()) && meta != 0) {
            return;
        }
        Integer result = onPlace ? freezeResultOnPlace.get(block) : freezeResultNatural.get(block);
        if (result != null) {
            world.setBlockWithNotify(x, y, z, result.intValue());
        }
    }

    static {
        freezeResultOnPlace.put(Blocks.FLUID_WATER_STILL.id(), Blocks.ICE.id());
        freezeResultOnPlace.put(Blocks.FLUID_LAVA_STILL.id(), Blocks.OBSIDIAN.id());
        freezeResultNatural.put(Blocks.FLUID_WATER_STILL.id(), Blocks.ICE.id());
        freezeResultNatural.put(Blocks.FLUID_LAVA_STILL.id(), Blocks.OBSIDIAN.id());
        freezeResultNatural.put(Blocks.STONE.id(), Blocks.PERMAFROST.id());
        freezeResultNatural.put(Blocks.COBBLE_STONE.id(), Blocks.COBBLE_PERMAFROST.id());
        freezeResultNatural.put(Blocks.ICE.id(), Blocks.PERMAICE.id());
    }
}

