/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import org.jspecify.annotations.Nullable;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTagDispatcher;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.Effects;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRendererDispatcher;
import teamport.aether.effect.ILockInteractable;
import teamport.aether.effect.PoisonEffect;
import teamport.aether.effect.RemedyEffect;
import teamport.aether.effect.render.PoisonEffectRenderer;
import teamport.aether.effect.render.RemedyEffectRenderer;
import teamport.aether.entity.boss.slider.MobBossSlider;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.entity.boss.valkyrie.queen.MobBossValkyrie;
import teamport.aether.entity.monster.aechorplant.MobAechorPlant;
import teamport.aether.entity.monster.cockatrice.MobCockatrice;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.monster.sentry.MobSentry;
import teamport.aether.entity.monster.valkyrie.MobValkyrie;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class AetherEffects {
    private static boolean hasInit = false;
    public static Effect poisonEffect;
    public static Effect remedyEffect;
    private static final Tag<Effect> IMMUNE_TO_POISON;

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        AetherEffects.assignEffects();
        AetherEffects.registerEffects();
        if (!EnvironmentHelper.isServerEnvironment()) {
            AetherEffects.assignEffectRenderers();
        }
    }

    private static void assignEffects() {
        poisonEffect = new PoisonEffect("effect.aether.poison", "aether:poison", new ArrayList(), EffectTimeType.KEEP, 10).setDefaultDuration(120);
        remedyEffect = new RemedyEffect("effect.aether.remedy", "aether:remedy", new ArrayList(), EffectTimeType.RESET, 1).setDefaultDuration(240);
        AetherEffects.registerLock(poisonEffect, remedyEffect);
    }

    private static void registerEffects() {
        Effects effects = Effects.getInstance();
        effects.register(AetherEffects.poisonEffect.id, (Object)poisonEffect);
        effects.register(AetherEffects.remedyEffect.id, (Object)remedyEffect);
        effects.register("aether:extra_health", (Object)Effects.EXTRA_HEALTH);
        IMMUNE_TO_POISON.tag((ITaggable)poisonEffect);
        EffectTagDispatcher.setImmunityFor(MobAechorPlant.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobCockatrice.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobSentry.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossSlider.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobValkyrie.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossValkyrie.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobFireMinion.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossSunspirit.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
    }

    private static void assignEffectRenderers() {
        EffectRendererDispatcher dispatcher = EffectRendererDispatcher.getInstance();
        dispatcher.addDispatch((Object)poisonEffect, (Object)new PoisonEffectRenderer<Effect>(poisonEffect, "/assets/aether/textures/other/poisonvignette.png", 8526027, "aether:gui/hud/poison/").setIcon("icon_poison.png"));
        dispatcher.addDispatch((Object)remedyEffect, (Object)new RemedyEffectRenderer<Effect>(remedyEffect, "/assets/aether/textures/other/curevignette.png", 39874, "aether:gui/hud/remedy/").setIcon("icon_remedy.png"));
    }

    public static void registerLock(Effect affected, Effect lock) {
        LookupLooks.instance.addEntry(affected, lock);
    }

    public static boolean add(Entity entity, Effect newEffect, int amount) {
        if (!(entity instanceof IHasEffects)) {
            return false;
        }
        EffectStack stack = new EffectStack((IHasEffects)entity, newEffect, amount);
        return AetherEffects.add(entity, stack);
    }

    public static boolean add(Entity entity, EffectStack stackToAdd) {
        if (!(entity instanceof IHasEffects)) {
            return false;
        }
        IHasEffects hasEffects = (IHasEffects)entity;
        for (EffectStack currStack : hasEffects.getContainer().getEffects()) {
            Effect currEffect = currStack.getEffect();
            int currMax = currEffect.getMaxStack();
            if (currEffect != stackToAdd.getEffect() || currStack.getAmount() + stackToAdd.getAmount() < currMax) continue;
            int amountToAdd = currMax - currStack.getAmount();
            currStack.add(amountToAdd, hasEffects.getContainer());
            return true;
        }
        if (AetherEffects.isLocked(stackToAdd, hasEffects.getContainer())) {
            return false;
        }
        stackToAdd.start(hasEffects.getContainer());
        hasEffects.getContainer().add(stackToAdd);
        return true;
    }

    public static <T> boolean isLocked(EffectStack effectStack, EffectContainer<T> effectContainer) {
        Effect effectToAdd = effectStack.getEffect();
        Effect effectBlocker = LookupLooks.instance.getLocker(effectToAdd);
        if (effectBlocker == null) {
            return false;
        }
        Object parent = effectContainer.getParent();
        if (parent instanceof IHasEffects && parent instanceof Mob && effectBlocker instanceof ILockInteractable && effectContainer.hasEffect(effectBlocker)) {
            ((ILockInteractable)effectBlocker).lockTriggered((IHasEffects)parent);
            effectContainer.remove(effectToAdd);
            return true;
        }
        return false;
    }

    static {
        IMMUNE_TO_POISON = Tag.of((String)"immune_to_poison");
    }

    public static class LookupLooks {
        public static final LookupLooks instance = new LookupLooks();
        public final Map<Effect, Effect> locker = new HashMap<Effect, Effect>();
        public final Map<Effect, HashSet<Effect>> lockedEffects = new HashMap<Effect, HashSet<Effect>>();

        public void addEntry(Effect getLocked, Effect lock) {
            this.locker.put(getLocked, lock);
            if (this.lockedEffects.containsKey(lock)) {
                HashSet<Effect> effects = this.lockedEffects.get(lock);
                effects.add(getLocked);
                return;
            }
            HashSet<Effect> effects = new HashSet<Effect>();
            effects.add(getLocked);
            this.lockedEffects.put(lock, effects);
        }

        public @Nullable Effect getLocker(Effect id) {
            return this.locker.getOrDefault(id, null);
        }

        public @Nullable Set<Effect> getLockedEffects(Effect id) {
            return this.lockedEffects.getOrDefault(id, null);
        }
    }
}

