/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.entity.DamageInstance;

public class MobUtil {
    private MobUtil() {
    }

    public static void knockback(Entity target, Entity attacker, float knockBackStrength, float lift) {
        if ((double)knockBackStrength < 0.001) {
            throw new RuntimeException("Cannot multiply speed by zero!");
        }
        double distX = attacker.x - target.x;
        double distZ = attacker.z - target.z;
        float horizonalDistance = Math.max(0.001f, MathHelper.sqrt((double)(distX * distX + distZ * distZ)));
        target.xd /= 2.0;
        target.yd /= 2.0;
        target.zd /= 2.0;
        target.xd -= distX / (double)horizonalDistance * (double)knockBackStrength;
        target.yd += (double)lift;
        target.zd -= distZ / (double)horizonalDistance * (double)knockBackStrength;
        target.xo = target.x;
        target.yo = target.y;
        target.zo = target.z;
    }

    public static boolean multiHit(Entity attacker, Entity victim, DamageInstance ... instances) {
        if (instances == null) {
            return false;
        }
        if (instances.length < 2) {
            DamageInstance instance = instances[0];
            return victim.hurt(attacker, instance.getDamage(), instance.getType());
        }
        boolean cumulativeAccept = true;
        int cumulativeDamage = 0;
        for (DamageInstance instance : instances) {
            cumulativeAccept = victim.hurt(attacker, cumulativeDamage += instance.damage, instance.getType());
        }
        return cumulativeAccept;
    }

    public static boolean killMob(Mob mob) {
        return MobUtil.killMob(mob, null);
    }

    public static boolean killMob(Mob mob, Entity attack) {
        mob.setHealthRaw(0);
        mob.playDeathSound();
        mob.onDeath(attack);
        return true;
    }
}

