/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.phow;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.entity.animal.phow.MobPhow;
import teamport.aether.entity.animal.phow.ModelPhow;

@Environment(value=EnvType.CLIENT)
public class MobRendererPhow
extends MobRenderer<MobPhow> {
    public MobRendererPhow(ModelBase modelbase, float shadowSize) {
        super(modelbase, shadowSize);
        this.setArmorModel(modelbase);
    }

    public float limbSway(MobPhow cow, float partialTick) {
        if (!(this.mainModel instanceof ModelPhow)) {
            return super.limbSway((Mob)cow, partialTick);
        }
        ModelPhow model = (ModelPhow)this.mainModel;
        float wingFold = MathHelper.lerp((float)cow.getWingFoldO(), (float)cow.getWingFold(), (float)partialTick);
        float wingAngle = MathHelper.lerp((float)cow.getWingAngleO(), (float)cow.getWingAngle(), (float)partialTick);
        float wingBend = -((float)Math.acos(wingFold));
        float x = 32.0f * wingFold / 4.0f;
        float y = -32.0f * (float)Math.sqrt(1.0f - wingFold * wingFold) / 4.0f;
        float z = 0.0f;
        float x2 = x * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        float y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        model.getLeftWingInner().setRotationPoint(4.0f + x2, y2 + 6.0f, z);
        model.getRightWingInner().setRotationPoint(-4.0f - x2, y2 + 6.0f, z);
        x2 = (x *= 3.0f) * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        model.getLeftWingOuter().setRotationPoint(4.0f + x2, y2 + 6.0f, z);
        model.getRightWingOuter().setRotationPoint(-4.0f - x2, y2 + 6.0f, z);
        model.getLeftWingInner().zRot = wingAngle + wingBend + 1.5707964f;
        model.getLeftWingOuter().zRot = wingAngle - wingBend + 1.5707964f;
        model.getRightWingInner().zRot = -(wingAngle + wingBend - 1.5707964f);
        model.getRightWingOuter().zRot = -(wingAngle - wingBend + 1.5707964f);
        return wingBend;
    }

    private boolean renderSaddledPhow(MobPhow entity, int i) {
        this.bindTexture("/assets/aether/textures/entity/phow/phow_saddle.png");
        return i == 0 && entity != null && entity.getSaddled();
    }

    public boolean prepareArmor(MobPhow entity, int renderPass, float partialTick) {
        return this.renderSaddledPhow(entity, renderPass);
    }
}

