/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.sheepuff;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import teamport.aether.block.AetherBlocks;
import teamport.aether.entity.animal.MobAetherAnimal;
import teamport.aether.item.AetherItemTags;

public class MobSheepuff
extends MobAetherAnimal {
    protected static final float[][] FLEECE_COLOR_TABLE = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int growthTimer;
    private int timeSheepEating;
    private int prevTimeSheepEating;

    public MobSheepuff(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"sheepuff");
        this.growthTimer = this.random.nextInt(100) + 100;
        this.setSize(0.9f, 1.3f);
    }

    public void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (Object)0, Byte.class);
        this.entityData.define(17, (Object)0, Byte.class);
    }

    public void spawnInit() {
        this.setFleeceColor(MobSheepuff.getRandomFleeceColor(this.random));
        if (this.random.nextInt(5) == 0) {
            this.setPuffed(true);
        }
    }

    public void dropDeathItems() {
        super.dropDeathItems();
        if (!this.getSheared() && !this.getPuffed()) {
            this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, this.getFleeceColor().blockMeta), 0.0f);
        }
        if (this.getPuffed()) {
            this.dropItem(new ItemStack(Blocks.WOOL.id(), 2, this.getFleeceColor().blockMeta), 0.0f);
        }
    }

    public boolean interact(@NonNull Player player) {
        boolean canShear;
        if (this.world == null) {
            return super.interact(player);
        }
        if (super.interact(player)) {
            return true;
        }
        ItemStack heldItem = player.inventory.getCurrentItem();
        if (heldItem == null) {
            return false;
        }
        if (heldItem.getItem() instanceof ItemDye) {
            if (!this.world.isClientSide) {
                DyeColor newColor = DyeColor.colorFromItemMeta((int)heldItem.getMetadata());
                if (this.getFleeceColor() != newColor && heldItem.consumeItem(player)) {
                    this.setFleeceColor(newColor);
                }
            }
            return true;
        }
        if (!(heldItem.getItem() instanceof ItemToolShears)) {
            return false;
        }
        boolean bl = canShear = this.getPuffed() || !this.getSheared() && !this.getPuffed();
        if (!canShear) {
            return false;
        }
        if (!this.world.isClientSide) {
            if (this.getPuffed()) {
                this.setPuffed(false);
            } else {
                this.setSheared(true);
            }
            int woolCount = 2 + this.random.nextInt(3);
            int meta = this.getFleeceColor().blockMeta;
            for (int i = 0; i < woolCount; ++i) {
                EntityItem entityItem = this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, meta), 1.0f);
                entityItem.yd += (double)(this.random.nextFloat() * 0.05f);
                entityItem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                entityItem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            }
        }
        heldItem.damageItem(1, (Entity)player);
        if (heldItem.stackSize <= 0) {
            player.destroyCurrentEquippedItem();
        }
        return true;
    }

    public void onItemInteract(ItemStack itemStack) {
        boolean canShear;
        boolean bl = canShear = this.getPuffed() || !this.getSheared() && !this.getPuffed();
        if (itemStack.getItem() instanceof ItemToolShears && canShear) {
            if (!this.world.isClientSide) {
                if (this.getPuffed()) {
                    this.setPuffed(false);
                } else {
                    this.setSheared(true);
                }
                int woolCount = 2 + this.random.nextInt(3);
                for (int i = 0; i < woolCount; ++i) {
                    EntityItem entityItem = this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, this.getFleeceColor().blockMeta), 1.0f);
                    entityItem.yd += (double)(this.random.nextFloat() * 0.05f);
                    entityItem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityItem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemStack.damageItem(1, null);
        }
    }

    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.getSheared());
        tag.putBoolean("Puffed", this.getPuffed());
        tag.putByte("Color", (byte)this.getFleeceColor().blockMeta);
        tag.putShort("GrowthTimer", (short)this.growthTimer);
    }

    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        this.setPuffed(tag.getBoolean("Puffed"));
        this.setFleeceColor(DyeColor.colorFromBlockMeta((int)tag.getByte("Color")));
        this.setGrowthTimer(tag.getShort("GrowthTimer"));
    }

    public boolean isMovementBlocked() {
        return super.isMovementBlocked() || this.getIsSheepEating();
    }

    public boolean getIsSheepEating() {
        return this.entityData.getByte(17) != 0;
    }

    public void setIsSheepEating(boolean value) {
        this.entityData.set(17, (Object)((byte)(value ? 1 : 0)));
    }

    public void onLivingUpdate() {
        if (this.world == null) {
            return;
        }
        super.onLivingUpdate();
        if (!this.getPuffed()) {
            ++this.growthTimer;
        }
        if (this.getPuffed()) {
            this.setSheared(false);
        }
        if (this.getSheared()) {
            this.setPuffed(false);
        }
        if (this.getPuffed()) {
            this.fallDistance = 0.0f;
            if (this.yd < -0.05) {
                this.yd *= 0.4;
            }
        }
        if (!this.getPuffed() && this.growthTimer > 400) {
            this.growthTimer = 0;
            Block<?> blockBelow = this.getBlockBelow();
            if (this.isValidGrass(blockBelow) && !this.world.isClientSide) {
                this.setIsSheepEating(true);
            }
            this.timeSheepEating = 0;
            this.prevTimeSheepEating = 0;
        }
        if (this.getIsSheepEating()) {
            this.prevTimeSheepEating = this.timeSheepEating++;
            int x = MathHelper.floor((double)this.x);
            int y = MathHelper.floor((double)(this.y - 0.1));
            int z = MathHelper.floor((double)this.z);
            if (this.timeSheepEating >= 5 && this.timeSheepEating <= 35 && this.timeSheepEating % 5 == 0 && !this.world.isClientSide) {
                this.world.playBlockSoundEffect(null, this.x + 0.5, this.y + 0.5, this.z + 0.5, AetherBlocks.GRASS_AETHER, EnumBlockSoundEffectType.DIG);
            }
            if (this.prevTimeSheepEating == 35 && !this.world.isClientSide && this.isValidGrass(this.getBlockBelow())) {
                int dirtId = this.getBlockBelow() == AetherBlocks.GRASS_AETHER ? AetherBlocks.DIRT_AETHER.id() : Blocks.DIRT.id();
                this.world.playBlockEvent(null, 2001, x, y, z, this.world.getBlockId(x, y, z));
                this.world.setBlockWithNotify(x, y, z, dirtId);
                if (this.getSheared()) {
                    this.setSheared(false);
                } else {
                    this.setPuffed(true);
                }
            }
            if (this.prevTimeSheepEating >= 40) {
                this.prevTimeSheepEating = 0;
                this.timeSheepEating = 0;
                if (!this.world.isClientSide) {
                    this.setIsSheepEating(false);
                }
            }
        }
    }

    private Block<?> getBlockBelow() {
        return this.world.getBlock(MathHelper.floor((double)this.x), MathHelper.floor((double)(this.y - 0.1)), MathHelper.floor((double)this.z));
    }

    private boolean isValidGrass(Block<?> block) {
        return block == Blocks.GRASS || block == Blocks.GRASS_RETRO || block == AetherBlocks.GRASS_AETHER;
    }

    public String getLivingSound() {
        return "mob.sheep";
    }

    public String getHurtSound() {
        return "mob.sheep";
    }

    public String getDeathSound() {
        return "mob.sheep";
    }

    public DyeColor getFleeceColor() {
        return DyeColor.colorFromBlockMeta((int)(this.entityData.getByte(16) & 0xF));
    }

    public void setFleeceColor(DyeColor color) {
        byte woolState = this.entityData.getByte(16);
        this.entityData.set(16, (Object)((byte)(woolState & 0xFFFFFFF0 | color.blockMeta & 0xF)));
    }

    public boolean getSheared() {
        return (this.entityData.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte woolState = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (Object)((byte)(woolState | 0x10)));
        } else {
            this.entityData.set(16, (Object)((byte)(woolState & 0xFFFFFFEF)));
        }
    }

    public boolean getPuffed() {
        return (this.entityData.getByte(16) & 0x20) != 0;
    }

    public void setPuffed(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (Object)((byte)(byte0 | 0x20)));
        } else {
            this.entityData.set(16, (Object)((byte)(byte0 & 0xFFFFFFDF)));
        }
    }

    public static DyeColor getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.CYAN;
        }
        if (i < 10) {
            return DyeColor.LIGHT_BLUE;
        }
        if (i < 15) {
            return DyeColor.LIME;
        }
        if (i < 18) {
            return DyeColor.PURPLE;
        }
        return random.nextInt(500) != 0 ? DyeColor.WHITE : DyeColor.PINK;
    }

    public int getTimeSheepEating() {
        return this.timeSheepEating;
    }

    public int getPrevTimeSheepEating() {
        return this.prevTimeSheepEating;
    }

    public boolean isFavouriteItem(ItemStack itemStack) {
        Block block;
        if (itemStack == null) {
            return false;
        }
        if (itemStack.itemID < Blocks.blocksList.length && (block = Blocks.blocksList[itemStack.itemID]) != null && block.hasTag(BlockTags.SHEEPS_FAVOURITE_BLOCK)) {
            return true;
        }
        return itemStack.getItem().hasTag(AetherItemTags.NATURE_STAFF_FOLLOW);
    }

    public void setGrowthTimer(int growthTimer) {
        this.growthTimer = growthTimer;
    }

    public void jump() {
        if (this.getIsSheepEating()) {
            this.yd = 0.0;
        } else if (this.getPuffed()) {
            this.yd = 1.5;
            this.xd += this.random.nextGaussian() * 0.5;
            this.zd += this.random.nextGaussian() * 0.5;
        } else {
            this.yd = 0.42f;
        }
    }
}

