/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss.slider;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.MaterialLiquid;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.block.AetherBlocks;
import teamport.aether.block.dungeon.BlockLogicChestLocked;
import teamport.aether.block.dungeon.BlockLogicDungeonDoor;
import teamport.aether.block.dungeon.BlockLogicLocked;
import teamport.aether.block.dungeon.BlockLogicTrapped;
import teamport.aether.entity.DamageInstance;
import teamport.aether.entity.MobUtil;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.MobBoss;
import teamport.aether.entity.player.MessageMaker;
import teamport.aether.entity.player.PlayerUntil;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.item.item_tool.ItemToolPickaxeAether;
import teamport.aether.world.feature.util.map.DungeonMap;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobBossSlider
extends MobBoss {
    private State currentState = State.ASLEEP;
    private @NonNull Direction moveDirection = Direction.NONE;
    public static final float BASE_SPEED = 15.0f;
    private float blocksToMove = 0.0f;
    private boolean allowedToMove;
    private int attackCoolDown = 0;
    public static final float ANGER_THRESHOLD = 0.5f;
    public static final float BASE_DAMAGE = 10.0f;
    public static final int MAX_ATTACK_COOL_DOWN = 50;
    public static final int MIN_ATTACK_COOL_DOWN = 10;
    public static final int WAKEUP_TIMER = 14;
    public int wakeUpTimer = 0;
    private double slamY = -1.0;
    private boolean slamGoingDown = false;
    private float deformX;
    private int deformY;
    private int deformZ;
    static final int DATA_STATE = 17;
    static final int DATA_ALLOW_MOVEMENT = 18;
    static final int DATA_MOVEMENT_DIRECTION = 19;
    static final int DATA_MOVEMENT_AMOUNT = 20;
    private final List<Player> creativeAttackersList = new ArrayList<Player>();

    public MobBossSlider(World world) {
        super(world);
        this.yRot = 0.0f;
        this.xRot = 0.0f;
        this.deformZ = 1;
        this.speed = 15.0f;
        this.scoreValue = 10000;
        this.setSize(2.0f, 2.0f);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"boss_slider");
        this.chatColor = (byte)(TextFormatting.BROWN.id & 0xFF);
    }

    protected void defineSynchedData() {
        this.entityData.define(17, (Object)State.ASLEEP.ordinal(), Integer.class);
        this.entityData.define(18, (Object)0, Integer.class);
        this.entityData.define(19, (Object)Direction.NONE.ordinal(), Integer.class);
        this.entityData.define(20, (Object)0, Integer.class);
    }

    @Override
    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        tag.putString("state", this.currentState.toString());
        tag.putInt("attackCoolDown", this.attackCoolDown);
        tag.putBoolean("allowedToMove", this.allowedToMove);
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        try {
            this.currentState = State.valueOf(tag.getString("state"));
        }
        catch (IllegalArgumentException e) {
            this.setState(State.ASLEEP);
            this.returnToOriginalState();
        }
        this.attackCoolDown = tag.getInteger("attackCoolDown");
        this.allowedToMove = tag.getBoolean("allowedToMove");
        super.readAdditionalSaveData(tag);
    }

    public int getAmbientSoundInterval() {
        return 800;
    }

    public String getLivingSound() {
        return "ambient.cave.cave";
    }

    public void playLivingSound() {
        if (this.currentState != State.ASLEEP || this.world == null) {
            return;
        }
        this.world.playSoundAtEntity(null, (Entity)this, this.getLivingSound(), 1.0f, 1.0f);
    }

    public String getHurtSound() {
        return "step.stone";
    }

    public String getDeathSound() {
        return "aether:mob.slider.death";
    }

    private void playCollidingSound() {
        if (this.world != null) {
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.slider.collide", 1.6f + this.random.nextFloat(), 0.45f + this.random.nextFloat());
        }
    }

    public int getMaxHealth() {
        return 500;
    }

    public boolean isOnFire() {
        return false;
    }

    public void fireHurt() {
    }

    public void lavaHurt() {
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public String getEntityTexture() {
        if (this.isAwake() && !this.doingSlam() && this.wakeUpTimer <= 0) {
            if (this.isAngry()) {
                return "/assets/aether/textures/entity/boss_slider/slider_awake_red.png";
            }
            return "/assets/aether/textures/entity/boss_slider/slider_awake.png";
        }
        if (this.isAngry()) {
            return "/assets/aether/textures/entity/boss_slider/slider_sleep_red.png";
        }
        return "/assets/aether/textures/entity/boss_slider/slider_sleep.png";
    }

    public @NonNull String getDefaultEntityTexture() {
        return "/assets/aether/textures/entity/boss_slider/slider_awake.png";
    }

    private void createDamageParticle(int damage) {
        for (int i = 0; i < Math.min(10, damage + this.random.nextInt(2)) * 32 / 10; ++i) {
            float posZ;
            float posY;
            float posX;
            float faceX = 2.0f * this.random.nextFloat();
            float faceY = 2.0f * this.random.nextFloat();
            Direction dir = Direction.directions[this.random.nextInt(Direction.directions.length)];
            switch (dir) {
                case WEST: {
                    posX = (float)(this.x - 1.0);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z - 1.0 + (double)faceX);
                    break;
                }
                case EAST: {
                    posX = (float)(this.x + 1.0);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z - 1.0 + (double)faceX);
                    break;
                }
                case SOUTH: {
                    posX = (float)(this.x - 1.0 + (double)faceX);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z + 1.0);
                    break;
                }
                case NORTH: {
                    posX = (float)(this.x - 1.0 + (double)faceX);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z - 1.0);
                    break;
                }
                case DOWN: {
                    posX = (float)(this.x - 1.0 + (double)faceX);
                    posY = (float)this.y;
                    posZ = (float)(this.z - 1.0 + (double)faceY);
                    break;
                }
                default: {
                    posX = (float)(this.x - 1.0 + (double)faceX);
                    posY = (float)(this.y + 2.0);
                    posZ = (float)(this.z - 1.0 + (double)faceY);
                }
            }
            ParticleMaker.spawnParticle(this.world, "block", posX, posY, posZ, 0.0, 0.0, 0.0, AetherBlocks.COBBLE_HOLYSTONE.id());
        }
    }

    private void createSlamParticle(int slamRadius) {
        for (int particle = 0; particle < 16; ++particle) {
            double explosionX = this.x - (double)slamRadius + (double)this.world.rand.nextInt(slamRadius * 2);
            double explosionY = this.y - (double)slamRadius + (double)this.world.rand.nextInt(slamRadius * 2);
            double explosionZ = this.z - (double)slamRadius + (double)this.world.rand.nextInt(slamRadius * 2);
            MobBossSlider.doExplosionEffect(this.world, explosionX, explosionY, explosionZ);
        }
    }

    public AABB getBb() {
        return this.bb.copy();
    }

    public float getDeformX() {
        return this.deformX;
    }

    public int getDeformY() {
        return this.deformY;
    }

    public int getDeformZ() {
        return this.deformZ;
    }

    public boolean showBoundingBoxOnHover() {
        return !this.isAwake() && this.getHealth() > 0;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
        if (this.world == null) {
            return;
        }
        this.world.players.stream().filter(player -> player.distanceTo((Entity)this) < 32.0f).forEach(p -> {
            p.triggerAchievement((Stat)AetherAchievements.BRONZE);
            this.world.playSoundEffect((Entity)p, SoundCategory.WORLD_SOUNDS, p.x, p.y, p.z, "aether:achievement.bronze", 0.5f, 1.0f);
        });
        super.onDeath(entityKilledBy);
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (attacker == null && type == null && damage == 100) {
            return MobUtil.killMob((Mob)this);
        }
        if (this.world != null && !this.world.getDifficulty().canHostileMobsSpawn()) {
            return false;
        }
        if (this.isAwake() && type == DamageType.BLAST) {
            return super.hurt(attacker, damage / 4, type);
        }
        if (!(attacker instanceof Player)) {
            return false;
        }
        ItemStack item = ((Player)attacker).inventory.getCurrentItem();
        if (item == null || !(item.getItem() instanceof ItemToolPickaxe) && !(item.getItem() instanceof ItemToolPickaxeAether)) {
            if (!this.isAwake()) {
                String message = "<" + ((Player)attacker).getDisplayName() + "> " + I18n.getInstance().translateKey("boss_slider.hit_fail");
                MessageMaker.sendMessage((Player)attacker, message);
            }
            return false;
        }
        this.tryAwake();
        if (!((Player)attacker).gamemode.areMobsHostile()) {
            this.creativeAttackersList.add((Player)attacker);
        }
        this.target = attacker;
        ((AetherBossList)attacker).aether$TryAddBossList((Mob)this);
        this.performDeformation(attacker);
        this.createDamageParticle(damage);
        return super.hurt(attacker, (int)item.getStrVsBlock(AetherBlocks.COBBLE_HOLYSTONE), type);
    }

    private void performDeformation(Entity attacker) {
        double c;
        double a = Math.abs(this.x - attacker.x);
        if (a > (c = Math.abs(this.z - attacker.z))) {
            this.deformZ = 1;
            this.deformY = 0;
            if (this.x > attacker.x) {
                this.deformZ = -1;
            }
        } else {
            this.deformY = 1;
            this.deformZ = 0;
            if (this.z > attacker.z) {
                this.deformY = -1;
            }
        }
        this.deformX = 0.7f - (float)this.getHealth() / 875.0f;
    }

    @Override
    public boolean canFight() {
        return this.isAlive() && this.isAwake();
    }

    public void setState(State state) {
        this.currentState = state;
    }

    public boolean isAngry() {
        return (float)this.getHealth() / (float)this.getMaxHealth() < 0.5f;
    }

    public boolean isAwake() {
        return this.currentState != State.ASLEEP;
    }

    public void tryAwake() {
        if (this.world == null) {
            return;
        }
        if (!this.world.getDifficulty().canHostileMobsSpawn()) {
            return;
        }
        if (!this.isAwake()) {
            this.setState(State.AWAKE);
            DungeonMap.runWithDungeon(this.dungeonID, d -> d.lock(this.world));
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.slider.awaken", 1.0f, 1.0f);
            this.wakeUpTimer = 14;
        }
    }

    protected void stateAwake() {
        int moveAmount;
        if (this.world == null) {
            return;
        }
        if (this.world.getClosestPlayerToEntity((Entity)this, 80.0) == null) {
            this.setState(State.ASLEEP);
            this.returnToOriginalState();
        }
        if (this.target == null || this.world.rand.nextInt(10) == 0) {
            this.target = this.findPlayerToAttack();
            if (!this.creativeAttackersList.isEmpty()) {
                this.target = (Entity)this.creativeAttackersList.get(0);
                for (Player player : this.creativeAttackersList) {
                    if (!(this.distanceToSqr((Entity)player) < this.distanceToSqr(this.target))) continue;
                    this.target = player;
                }
            }
        } else if (this.distanceToSqr(this.target) > 6400.0) {
            this.target = null;
        }
        if (!this.allowedToMove || this.target == null || this.blocksToMove > 0.05f) {
            return;
        }
        float progress = (float)Math.max((double)((float)this.getHealth() / (float)this.getMaxHealth()), 0.32);
        this.attackCoolDown = (int)Math.floor(MathHelper.lerp((float)10.0f, (float)50.0f, (float)progress));
        this.allowedToMove = false;
        if (this.distanceToSqr(this.target) <= 25.0 && progress < 0.6f && this.random.nextInt(6) == 0) {
            this.moveDirection = Direction.UP;
            this.blocksToMove = 45.0f;
            this.speed = 30.0f;
            this.attackCoolDown = (int)Math.floor(MathHelper.lerp((double)10.0, (double)50.0, (double)0.5));
            this.currentState = State.SLAM;
            this.slamGoingDown = false;
            return;
        }
        this.moveDirection = this.calculateDirection(this.target);
        switch (this.moveDirection) {
            case WEST: 
            case EAST: {
                moveAmount = (int)Math.abs(this.x - this.target.x);
                break;
            }
            case DOWN: 
            case UP: {
                moveAmount = (int)Math.abs(this.y - this.target.y);
                break;
            }
            case SOUTH: 
            case NORTH: {
                moveAmount = (int)Math.abs(this.z - this.target.z);
                break;
            }
            default: {
                moveAmount = 0;
            }
        }
        this.blocksToMove = Math.min(25, Math.max(moveAmount + 1, 3));
        this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.slider.move", 1.6f + this.random.nextFloat(), 0.45f + this.random.nextFloat());
    }

    protected void stateAsleep() {
    }

    protected void stateSlam() {
        if (this.world == null) {
            return;
        }
        if (this.allowedToMove && !this.slamGoingDown) {
            this.slamGoingDown = true;
            this.slamY = -1.0;
            this.moveDirection = Direction.DOWN;
            this.blocksToMove = 999.0f;
        } else if (this.allowedToMove && this.slamY == this.y) {
            int slamRadius = 5;
            float launchSpeed = 0.75f;
            AABB boundingBox = AABB.getTemporaryBB((double)(this.x - 5.0), (double)this.y, (double)(this.z - 5.0), (double)(this.x + 5.0), (double)(this.y + 5.0), (double)(this.z + 5.0));
            List list = this.world.getEntitiesWithinAABB(Entity.class, boundingBox);
            for (Entity entity : list) {
                MobUtil.multiHit((Entity)this, entity, DamageInstance.inst((int)Math.floor(5.0f * this.getAngerModifier()), DamageType.FALL), DamageInstance.inst((int)Math.floor(7.5f * this.getAngerModifier()), DamageType.COMBAT), DamageInstance.inst(2, DamageType.GENERIC));
                switch (this.calculateDirection(entity)) {
                    case NORTH: {
                        entity.push(0.0, 0.375, -0.75);
                        break;
                    }
                    case SOUTH: {
                        entity.push(0.0, 0.375, 0.75);
                        break;
                    }
                    case EAST: {
                        entity.push(0.75, 0.375, 0.0);
                        break;
                    }
                    case WEST: {
                        entity.push(-0.75, 0.375, 0.0);
                    }
                }
                MobBossSlider.doExplosionEffect(entity.world, entity.x, entity.y, entity.z);
            }
            this.createSlamParticle(5);
            this.blocksToMove = 0.0f;
            this.moveDirection = Direction.NONE;
            this.currentState = State.AWAKE;
            this.speed = 15.0f;
            this.attackCoolDown = 50;
        }
        this.slamY = this.y;
    }

    public boolean doingSlam() {
        return this.currentState == State.SLAM;
    }

    public void tick() {
        super.baseTick();
        if (this.world == null) {
            return;
        }
        if (!this.world.getDifficulty().canHostileMobsSpawn()) {
            if (!this.isAwake()) {
                return;
            }
            this.setState(State.ASLEEP);
            this.returnToOriginalState();
            return;
        }
        this.lerpSlider();
        int blocksBroken = this.getBlocksBroken();
        if (blocksBroken >= 9) {
            this.allowedToMove = false;
            this.attackCoolDown = 50;
            return;
        }
        this.moveSlider();
        if (this.blocksToMove <= 0.05f) {
            this.yo = this.y = this.y % 1.0 < 0.5 ? Math.floor(this.y) : Math.ceil(this.y);
            this.xo = this.x;
            this.zo = this.z;
        }
        if (this.deformX > 0.01f) {
            this.deformX *= 0.8f;
        }
        if (!EnvironmentHelper.isClientWorld()) {
            if (--this.attackCoolDown <= 0) {
                this.allowedToMove = true;
            }
            this.currentState.getConsumer().accept(this);
        }
        this.updateEntityData();
        if (this.isAwake()) {
            --this.wakeUpTimer;
        }
    }

    public Player findPlayerToAttack() {
        if (this.world == null) {
            return null;
        }
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 32.0);
        if (entityplayer == null) {
            return null;
        }
        if (this.canEntityBeSeen((Entity)entityplayer) && entityplayer.gamemode.areMobsHostile()) {
            ((AetherBossList)entityplayer).aether$TryAddBossList((Mob)this);
            return entityplayer;
        }
        return null;
    }

    private void moveSlider() {
        if (!this.isAwake() || this.wakeUpTimer > 0) {
            return;
        }
        if (this.moveDirection == Direction.NONE) {
            this.blocksToMove = 0.0f;
            return;
        }
        float moveAmount = this.speed / 20.0f;
        if (this.blocksToMove > moveAmount) {
            this.move(moveAmount * (float)this.moveDirection.getOffsetX(), moveAmount * (float)this.moveDirection.getOffsetY(), moveAmount * (float)this.moveDirection.getOffsetZ());
            this.blocksToMove -= moveAmount;
        } else {
            this.move(this.blocksToMove * (float)this.moveDirection.getOffsetX(), this.blocksToMove * (float)this.moveDirection.getOffsetY(), this.blocksToMove * (float)this.moveDirection.getOffsetZ());
            this.blocksToMove = 0.0f;
        }
        if (this.x == this.xo && this.y == this.yo && this.z == this.zo) {
            this.moveDirection = Direction.UP;
        }
    }

    private int getBlocksBroken() {
        if (this.world == null) {
            return 0;
        }
        int blocksBroken = 0;
        if (this.blocksToMove <= 0.0f) {
            return blocksBroken;
        }
        int y = this.moveDirection == Direction.DOWN && this.currentState != State.SLAM ? -1 : 0;
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                while (y <= 2 && blocksBroken < 9) {
                    int x1 = (int)(this.x + (double)x);
                    int y1 = (int)(this.y + (double)y);
                    int z1 = (int)(this.z + (double)z);
                    Block block = this.world.getBlock(x1, y1, z1);
                    if (block != null && this.breakBlock(this.world, x1, y1, z1)) {
                        MobBossSlider.doExplosionEffect(this.world, x1, y1, z1);
                        this.blocksToMove -= 0.5f * Math.min(block.getHardness() / 3.0f, 1.0f);
                        ++blocksBroken;
                    }
                    ++y;
                }
            }
        }
        return blocksBroken;
    }

    private void updateEntityData() {
        if (EnvironmentHelper.isServerEnvironment()) {
            this.entityData.set(17, (Object)this.currentState.ordinal());
            this.entityData.set(18, (Object)(this.allowedToMove ? 1 : 0));
            this.entityData.set(19, (Object)this.moveDirection.ordinal());
            this.entityData.set(20, (Object)Float.floatToIntBits(this.blocksToMove));
            return;
        }
        if (EnvironmentHelper.isClientWorld()) {
            this.currentState = State.values()[this.entityData.getInt(17)];
            this.allowedToMove = this.entityData.getInt(18) > 0;
            this.moveDirection = Direction.values()[this.entityData.getInt(19)];
            this.blocksToMove = Float.intBitsToFloat(this.entityData.getInt(20));
        }
    }

    private void lerpSlider() {
        if (this.newPosRotationIncrements > 0) {
            double lerpYRot;
            double lerpXD = this.x + (this.newPosX - this.x) / (double)this.newPosRotationIncrements;
            double lerpYD = this.y + (this.newPosY - this.y) / (double)this.newPosRotationIncrements;
            double lerpZD = this.z + (this.newPosZ - this.z) / (double)this.newPosRotationIncrements;
            double lerpXRot = this.newRotationPitch - (double)this.xRot;
            for (lerpYRot = this.newRotationYaw - (double)this.yRot; lerpYRot < -180.0; lerpYRot += 360.0) {
            }
            while (lerpYRot >= 180.0) {
                lerpYRot -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + lerpYRot / (double)this.newPosRotationIncrements);
            this.xRot = (float)((double)this.xRot + lerpXRot / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPos(lerpXD, lerpYD, lerpZD);
            this.setRot(this.yRot, this.xRot);
        }
    }

    public Direction calculateDirection(Entity entity) {
        double deltaX = this.x - entity.x;
        double deltaZ = this.z - entity.z;
        double deltaY = this.y;
        deltaY = entity instanceof Player ? (deltaY -= PlayerUntil.getY((Player)entity)) : (deltaY -= entity.y);
        if (Math.abs(deltaY) >= (double)entity.bbHeight) {
            return deltaY < 0.0 ? Direction.UP : Direction.DOWN;
        }
        if (Math.abs(deltaX) > Math.abs(deltaZ)) {
            return deltaX < 0.0 ? Direction.EAST : Direction.WEST;
        }
        return deltaZ < 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public boolean breakBlock(@NonNull World world, int x, int y, int z) {
        if (this.getHealth() <= 0) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        if (block == null || block.getLogic() instanceof BlockLogicTrapped || block.getLogic() instanceof BlockLogicLocked || block.getLogic() instanceof BlockLogicDungeonDoor || block.getLogic() instanceof BlockLogicChestLocked || block.getMaterial() instanceof MaterialLiquid || block.getHardness() < 0.0f) {
            return false;
        }
        block.dropBlockWithCause(world, EnumDropCause.EXPLOSION, x, y, z, world.getBlockMetadata(x, y, z), world.getTileEntity(x, y, z), null);
        world.setBlockWithNotify(x, y, z, 0);
        return true;
    }

    public static void doExplosionEffect(World world, double x, double y, double z) {
        for (int particle = 0; particle < 16; ++particle) {
            double xParticle = x + 0.5 + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            double yParticle = y + 0.5 + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            double zParticle = z + 0.5 + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            ParticleMaker.spawnParticle(world, "explode", xParticle, yParticle, zParticle, 0.0, 0.0, 0.0, 0);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "random.explode", 0.5f, (1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f);
    }

    public boolean collidesWith(Entity entity) {
        if (0.25f >= this.blocksToMove) {
            return super.collidesWith(entity);
        }
        if (entity instanceof Player) {
            if (!((Player)entity).gamemode.isPlayerInvulnerable()) {
                MobUtil.multiHit((Entity)this, entity, DamageInstance.inst((int)Math.floor(10.0f * this.getAngerModifier()), DamageType.FALL), DamageInstance.inst((int)Math.floor(5.0f * this.getAngerModifier()), DamageType.COMBAT), DamageInstance.inst(2, DamageType.GENERIC));
            }
            return super.collidesWith(entity);
        }
        MobBossSlider.doExplosionEffect(entity.world, entity.x, entity.y, entity.z);
        this.playCollidingSound();
        return super.collidesWith(entity);
    }

    public boolean isMovementBlocked() {
        return super.isMovementBlocked() || !this.isAwake();
    }

    public float getAngerModifier() {
        return 1.0f + (float)(this.getMaxHealth() - this.getHealth()) / (float)this.getMaxHealth();
    }

    public static enum State {
        AWAKE(MobBossSlider::stateAwake),
        SLAM(MobBossSlider::stateSlam),
        ASLEEP(MobBossSlider::stateAsleep);

        public final Consumer<MobBossSlider> consumer;

        private State(Consumer<MobBossSlider> consumer) {
            this.consumer = consumer;
        }

        public Consumer<MobBossSlider> getConsumer() {
            return this.consumer;
        }
    }
}

