/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;

public abstract class MobMonsterAether
extends MobMonster
implements Enemy {
    protected MobMonsterAether(@Nullable World world) {
        super(world);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (super.hurt(attacker, i, type)) {
            if (this.passenger != attacker && this.vehicle != attacker && attacker != this) {
                this.target = attacker;
            }
            return true;
        }
        return false;
    }

    public boolean canSpawnHere() {
        int blockX = MathHelper.floor((double)this.x);
        int blockY = MathHelper.floor((double)this.bb.minY);
        int blockZ = MathHelper.floor((double)this.z);
        if (this.world == null || this.world.getSavedLightValue(LightLayer.Block, blockX, blockY, blockZ) > 0) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

