/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.fireminion;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.DamageInstance;
import teamport.aether.entity.MobUtil;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobFireMinion
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    public MobFireMinion(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"fire_minion");
        this.moveSpeed = 4.0f;
        this.attackStrength = 10;
        this.fireImmune = true;
        this.maxFireTicks = 20;
        this.scoreValue = 5000;
        this.setSize(1.0f, 2.0f);
        this.canBreatheUnderwater();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    public int getLightmapCoord(float partialTick) {
        return this.world == null ? super.getLightmapCoord(partialTick) : this.world.getLightmapCoord(15, 15);
    }

    public int getMaxHealth() {
        return 40;
    }

    protected void attackEntity(@NonNull Entity target, float distance) {
        if (this.attackTime <= 0 && distance < 2.0f && target.bb.maxY > this.bb.minY && target.bb.minY < this.bb.maxY) {
            this.attackTime = 20;
            MobUtil.multiHit((Entity)this, target, DamageInstance.inst(this.attackStrength, DamageType.FIRE), DamageInstance.inst(this.attackStrength / 2, DamageType.COMBAT));
            target.remainingFireTicks = 300;
            target.maxFireTicks = 300;
        }
    }

    protected Entity findPlayerToAttack() {
        if (this.world == null) {
            return super.findPlayerToAttack();
        }
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        return entityplayer != null && this.canEntityBeSeen((Entity)entityplayer) && entityplayer.getGamemode().areMobsHostile() ? entityplayer : null;
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (type == DamageType.FIRE) {
            return false;
        }
        return super.hurt(attacker, damage, type);
    }

    public void tick() {
        super.tick();
        if (this.getHealth() > 0) {
            this.maxFireTicks = 20;
            for (int j = 0; j < 4; ++j) {
                double a = this.random.nextFloat() - 0.5f;
                double b = this.random.nextFloat();
                double c = this.random.nextFloat() - 0.5f;
                double x = this.x + a * b;
                double y = this.bb.minY + b;
                double z = this.z + c * b;
                if (EnvironmentHelper.isServerEnvironment()) continue;
                ParticleMaker.spawnParticle(this.world, "flame", x, y, z, 0.0, -0.075f, 0.0, 0);
            }
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "aether:mob.sunspirit.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.sunspirit.death";
    }

    public void playHurtSound() {
        if (this.world == null) {
            super.playHurtSound();
            return;
        }
        this.world.playSoundAtEntity(null, (Entity)this, this.getHurtSound(), 0.5f, (this.random.nextFloat() + this.random.nextFloat()) * 1.5f + 0.25f);
    }

    public void playDeathSound() {
        if (this.world == null) {
            super.playDeathSound();
            return;
        }
        this.world.playSoundAtEntity(null, (Entity)this, this.getDeathSound(), 0.5f, (this.random.nextFloat() + this.random.nextFloat()) * 1.5f + 0.25f);
    }

    @Override
    public boolean canSpawnHere() {
        return this.world != null && this.world.getDifficulty().canHostileMobsSpawn() && this.world.checkIfAABBIsClear(this.bb) && this.world.getCubes((Entity)this, this.bb).isEmpty();
    }
}

