/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.fireminion;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

@Environment(value=EnvType.CLIENT)
public class ModelFireMinion
extends ModelBase {
    private final Cube bodyBottom;
    private final Cube bodyBrace;
    private final Cube bipedRightArm2;
    private final Cube bipedLeftArm2;
    private final Cube armRightBrace;
    private final Cube armLeftBrace;
    private final Cube head = new Cube(0, 0);
    private final Cube hair;
    private final Cube body;
    private final Cube armRight;
    private final Cube armLeft;

    public ModelFireMinion() {
        this.head.addBox(-4.0f, -9.0f, -3.0f, 8, 5, 7, 0.0f);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -4.0f, -4.0f, 8, 3, 8, 0.0f);
        this.hair.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body = new Cube(0, 12);
        this.body.addBox(-5.0f, -1.0f, -2.5f, 10, 6, 5, 0.0f);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bodyBottom = new Cube(0, 23);
        this.bodyBottom.addBox(-4.5f, 5.0f, -2.0f, 9, 5, 4, 0.0f);
        this.bodyBottom.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bodyBrace = new Cube(27, 27);
        this.bodyBrace.addBox(-4.5f, 10.0f, -2.0f, 9, 1, 4, 0.5f);
        this.bodyBrace.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.armRight = new Cube(30, 11);
        this.armRight.addBox(-2.5f, -3.5f, -2.5f, 5, 5, 5, 0.5f);
        this.armRight.setRotationPoint(-8.0f, 2.0f, 0.0f);
        this.bipedRightArm2 = new Cube(30, 11);
        this.bipedRightArm2.addBox(-2.5f, 1.5f, -2.5f, 5, 10, 5, 0.0f);
        this.bipedRightArm2.setRotationPoint(-8.0f, 2.0f, 0.0f);
        this.armRightBrace = new Cube(30, 26);
        this.armRightBrace.addBox(-2.5f, 6.5f, -2.5f, 5, 1, 5, 0.25f);
        this.armRightBrace.setRotationPoint(-8.0f, 2.0f, 0.0f);
        this.armLeft = new Cube(30, 11);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-2.5f, -3.5f, -2.5f, 5, 5, 5, 0.5f);
        this.armLeft.setRotationPoint(8.0f, 2.0f, 0.0f);
        this.bipedLeftArm2 = new Cube(30, 11);
        this.bipedLeftArm2.mirror = true;
        this.bipedLeftArm2.addBox(-2.5f, 1.5f, -2.5f, 5, 10, 5, 0.0f);
        this.bipedLeftArm2.setRotationPoint(8.0f, 2.0f, 0.0f);
        this.armLeftBrace = new Cube(30, 26);
        this.armLeftBrace.mirror = true;
        this.armLeftBrace.addBox(-2.5f, 6.5f, -2.5f, 5, 1, 5, 0.25f);
        this.armLeftBrace.setRotationPoint(8.0f, 2.0f, 0.0f);
    }

    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.hair.render(scale);
        this.body.render(scale);
        this.bodyBottom.render(scale);
        this.bodyBrace.render(scale);
        this.armRight.render(scale);
        this.bipedRightArm2.render(scale);
        this.armRightBrace.render(scale);
        this.armLeft.render(scale);
        this.bipedLeftArm2.render(scale);
        this.armLeftBrace.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        Cube var10000;
        this.head.yRot = headYaw / 57.29578f;
        this.head.xRot = headPitch / 57.29578f;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.armRight.xRot = 0.0f;
        this.armLeft.xRot = 0.0f;
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        this.armRight.yRot = 0.0f;
        this.armLeft.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.body.yRot = MathHelper.sin((float)(MathHelper.sqrt((double)f6) * 3.141593f * 2.0f)) * 0.2f;
            var10000 = this.armRight;
            var10000.yRot += this.body.yRot;
            var10000 = this.armLeft;
            var10000.yRot += this.body.yRot;
            var10000.xRot += this.body.xRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin((float)(f6 * 3.141593f));
            float f8 = MathHelper.sin((float)(this.onGround * 3.141593f)) * -(this.head.xRot - 0.7f) * 0.75f;
            var10000 = this.armRight;
            var10000.xRot = (float)((double)var10000.xRot - ((double)f7 * 1.2 + (double)f8));
            var10000.yRot += this.body.yRot * 2.0f;
            this.armRight.zRot = MathHelper.sin((float)(this.onGround * 3.141593f)) * -0.4f;
        }
        var10000 = this.armRight;
        var10000.zRot += MathHelper.cos((float)(limbPitch * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armLeft;
        var10000.zRot -= MathHelper.cos((float)(limbPitch * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armRight;
        var10000.xRot += MathHelper.sin((float)(limbPitch * 0.067f)) * 0.05f;
        var10000 = this.armLeft;
        var10000.xRot -= MathHelper.sin((float)(limbPitch * 0.067f)) * 0.05f;
        this.bodyBrace.xRot = this.bodyBottom.xRot = this.body.xRot;
        this.bodyBrace.yRot = this.bodyBottom.yRot = this.body.yRot;
        this.armLeftBrace.xRot = this.bipedLeftArm2.xRot = this.armLeft.xRot;
        this.armLeftBrace.yRot = this.bipedLeftArm2.yRot = this.armLeft.yRot;
        this.armLeftBrace.zRot = this.bipedLeftArm2.zRot = this.armLeft.zRot;
        this.armRightBrace.xRot = this.bipedRightArm2.xRot = this.armRight.xRot;
        this.armRightBrace.yRot = this.bipedRightArm2.yRot = this.armRight.yRot;
        this.armRightBrace.zRot = this.bipedRightArm2.zRot = this.armRight.zRot;
    }
}

