/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.mimic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.DyeColor;
import teamport.aether.block.AetherBlocks;
import teamport.aether.entity.monster.mimic.MimicEntry;

public class MimicRegistry {
    public static final MimicRegistry instance = new MimicRegistry();
    public final List<MimicEntry> MIMIC_ENTRY_LIST = new ArrayList<MimicEntry>();
    public static final MimicEntry DEFAULT = MimicEntry.mimicEntry(0, AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 0, AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 0);

    public static void init() {
    }

    protected MimicRegistry() {
        this.register();
    }

    private void register() {
        int meta;
        int variantSkinID = 0;
        this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_SKYROOT, AetherBlocks.CHEST_PLANKS_SKYROOT);
        this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_OAK, Blocks.CHEST_PLANKS_OAK);
        for (DyeColor dye : DyeColor.blockOrderedColors()) {
            meta = dye.blockMeta << 4;
            this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_OAK_PAINTED.id(), meta, Blocks.CHEST_PLANKS_OAK_PAINTED.id(), meta);
        }
        this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_BRONZE.id(), 0, AetherBlocks.CHEST_DUNGEON_BRONZE.id(), 0);
        this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_SILVER.id(), 0, AetherBlocks.CHEST_DUNGEON_SILVER.id(), 0);
        this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_GOLD.id(), 0, AetherBlocks.CHEST_DUNGEON_GOLD.id(), 0);
        for (DyeColor dye : DyeColor.blockOrderedColors()) {
            meta = dye.blockMeta << 4;
            this.addEntry(variantSkinID++, AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), meta, AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), meta);
        }
    }

    public void addEntry(int mimicVariant, int mimicChestId, int mimicChestMetadata, int chestID, int chestMetadata) {
        this.MIMIC_ENTRY_LIST.add(MimicEntry.mimicEntry(mimicVariant, mimicChestId, mimicChestMetadata, chestID, chestMetadata));
    }

    public void addEntry(int mimicVariant, Block<?> mimicChest, Block<?> chest) {
        this.MIMIC_ENTRY_LIST.add(MimicEntry.mimicEntry(mimicVariant, mimicChest.id(), 0, chest.id(), 0));
    }

    public static MimicEntry getMimicVariantByID(int mimicVariant) {
        mimicVariant %= MimicRegistry.instance.MIMIC_ENTRY_LIST.size();
        for (MimicEntry variant : MimicRegistry.instance.MIMIC_ENTRY_LIST) {
            if (variant.mimicVariant != mimicVariant) continue;
            return variant;
        }
        return DEFAULT;
    }

    public static MimicEntry getMimicVariantByMimicChest(int mimicChestID, int mimicMetadata) {
        for (MimicEntry variant : MimicRegistry.instance.MIMIC_ENTRY_LIST) {
            if (variant.mimicChestID != mimicChestID || variant.mimicChestMetadata != mimicMetadata) continue;
            return variant;
        }
        return DEFAULT;
    }

    public static MimicEntry getMimicVariantByChest(int chestID, int metadata) {
        for (MimicEntry variant : MimicRegistry.instance.MIMIC_ENTRY_LIST) {
            if (variant.chestID != chestID || variant.chestMetadata != metadata) continue;
            return variant;
        }
        return DEFAULT;
    }
}

