/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.mimic;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolAxe;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.AetherMod;
import teamport.aether.block.AetherBlockTags;
import teamport.aether.block.AetherBlocks;
import teamport.aether.block.dungeon.BlockLogicChestMimic;
import teamport.aether.block.entity.TileEntityMimic;
import teamport.aether.block.skyroot.BlockLogicPaintedChest;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.entity.monster.mimic.MimicEntry;
import teamport.aether.entity.monster.mimic.MimicRegistry;
import teamport.aether.helper.unboxed.IntPair;
import teamport.aether.item.accessory.AetherInvisibility;
import teamport.aether.item.item_tool.ItemToolAxeAether;
import teamport.aether.item.item_tool.ItemToolPickaxeAether;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class MobMimic
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    private int mimicTime;
    int mimicChestID = AetherBlocks.CHEST_MIMIC_SKYROOT.id();
    int mimicChestMetadata = 0;

    public MobMimic(World world) {
        super(world);
        this.setSize(1.0f, 1.8f);
        this.attackStrength = 5;
        this.scoreValue = 2000;
        this.mimicTime = 1200;
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"mimic");
        this.setSkinVariant(this.getSkinVariant());
    }

    public void spawnInit() {
        MimicEntry entry = MimicRegistry.getMimicVariantByID(this.getSkinVariant());
        this.setBlockData(entry.mimicChestID, entry.mimicChestMetadata);
    }

    public void setBlockData(int mimicChestID, int mimicChestMetadata) {
        this.mimicChestID = mimicChestID;
        this.mimicChestMetadata = mimicChestMetadata;
    }

    public void setChatColor(byte chatColor) {
        this.chatColor = chatColor;
    }

    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MimicChestID", this.mimicChestID);
        tag.putInt("MimicChestMetadata", this.mimicChestMetadata);
        ListTag lootTag = new ListTag();
        for (WeightedRandomLootObject lootObject : this.mobDrops) {
            ItemStack stack = lootObject.getDefinedItemStack();
            if (stack == null || stack.stackSize <= 0) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.writeToNBT(itemTag);
            lootTag.addTag((Tag)itemTag);
        }
        tag.put("MimicLoot", (Tag)lootTag);
    }

    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.mimicChestID = tag.getInteger("MimicChestID");
        this.mimicChestMetadata = tag.getInteger("MimicChestMetadata");
        this.mobDrops.clear();
        ListTag lootTag = tag.getList("MimicLoot");
        if (lootTag != null) {
            for (int i = 0; i < lootTag.tagCount(); ++i) {
                CompoundTag itemTag = (CompoundTag)lootTag.tagAt(i);
                ItemStack stack = ItemStack.readItemStackFromNbt((CompoundTag)itemTag);
                if (stack == null || stack.stackSize <= 0) continue;
                this.mobDrops.add(new WeightedRandomLootObject(stack));
            }
        }
    }

    public void dropDeathItems() {
        MimicEntry variant = MimicRegistry.getMimicVariantByID(this.getSkinVariant());
        this.dropItem(new ItemStack(variant.getChestID(), 1, variant.getChestMetadata()), 0.0f);
        for (WeightedRandomLootObject lootObject : this.mobDrops) {
            ItemStack stack = lootObject.getDefinedItemStack();
            if (stack == null) continue;
            this.dropItem(stack, 0.0f);
        }
    }

    public void updateAI() {
        super.updateAI();
        if (this.target == null && this.mimicTime-- == 0) {
            this.remove();
        }
    }

    public Entity findPlayerToAttack() {
        if (this.world == null) {
            return null;
        }
        Player player = this.world.getClosestPlayerToEntity((Entity)this, 64.0);
        if (player == null || !this.canEntityBeSeen((Entity)player) || !player.getGamemode().areMobsHostile()) {
            return null;
        }
        if (!(player instanceof AetherInvisibility)) {
            return player;
        }
        AetherInvisibility invPlayer = (AetherInvisibility)player;
        if (invPlayer.aether$isInvisible()) {
            Player newPlayer = this.world.getClosestPlayerToEntity((Entity)this, 2.0);
            if (newPlayer == null || !this.canEntityBeSeen((Entity)newPlayer) || !newPlayer.getGamemode().areMobsHostile()) {
                return null;
            }
            return newPlayer;
        }
        return player;
    }

    public void attackEntity(@NonNull Entity entity, float distance) {
        if (this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            this.attackTime = 20;
            int attack = this.attackStrength;
            if (this.isWallace()) {
                attack = (int)((double)attack * 1.5);
            }
            entity.hurt((Entity)this, attack, DamageType.COMBAT);
        }
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (damage > 0 && this.isWallace()) {
            damage = Math.max(1, damage / 3);
        }
        if (type == DamageType.FIRE) {
            return super.hurt(attacker, damage * 2, type);
        }
        return super.hurt(attacker, this.extraDamage(attacker, damage), type);
    }

    public int extraDamage(Entity attacker, int damage) {
        if (!(attacker instanceof Player)) {
            return damage;
        }
        ItemStack item = ((Player)attacker).inventory.getCurrentItem();
        if (item == null) {
            return damage;
        }
        Block block = Blocks.getBlock((int)this.mimicChestID);
        if (block == null) {
            return damage;
        }
        if (block.hasTag(AetherBlockTags.MINEABLE_BY_AETHER_AXE) && (item.getItem() instanceof ItemToolAxe || item.getItem() instanceof ItemToolAxeAether)) {
            return damage << 1;
        }
        if (block.hasTag(AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE) && (item.getItem() instanceof ItemToolPickaxe || item.getItem() instanceof ItemToolPickaxeAether)) {
            return damage << 1;
        }
        return damage;
    }

    public String getHurtSound() {
        Block block = Blocks.getBlock((int)this.mimicChestID);
        if (block == null) {
            return "step.wood";
        }
        return block.getSound().getStepSoundName();
    }

    public String getDeathSound() {
        Material material;
        Block block = Blocks.getBlock((int)this.mimicChestID);
        Material material2 = material = block == null ? Material.wood : block.getMaterial();
        if (material == Material.stone) {
            return "step.stone";
        }
        return "random.door_open";
    }

    public float getSoundVolume() {
        return 0.6f;
    }

    public int getMaxHealth() {
        return 80;
    }

    public void setLoot(List<ItemStack> loot) {
        if (loot == null || loot.isEmpty()) {
            return;
        }
        this.mobDrops.clear();
        for (ItemStack itemStack : loot) {
            if (itemStack == null || itemStack.stackSize <= 0) continue;
            this.mobDrops.add(new WeightedRandomLootObject(itemStack));
        }
    }

    public void remove() {
        if (this.isAlive()) {
            this.place();
        }
        super.remove();
    }

    @Override
    public String deathMessage(Player player) {
        String key = EntityDispatcher.nameKeyForClass(this.getClass()) + ".death_message";
        String deathMessage = AetherMod.TRANSLATOR.translateKey(key).replace("[PLAYER]", TextFormatting.RESET + String.format("<%s>", player.getDisplayName()) + TextFormatting.RESET + TextFormatting.RED);
        return TextFormatting.RED + deathMessage;
    }

    public float getHeadHeight() {
        return this.bbHeight;
    }

    private void place() {
        Direction[] check;
        WorldFeaturePoint point = WorldFeaturePoint.wfp((int)Math.round(this.x), (int)Math.round(this.y), (int)Math.round(this.z));
        for (Direction dir : check = new Direction[]{Direction.NONE, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN}) {
            WorldFeaturePoint dPoint = point.copy().moveInDirection(dir);
            if (!this.isSafe(this.world, dPoint)) continue;
            this.placeChest(dPoint);
            this.populateChest(dPoint);
            return;
        }
        this.placeChest(point);
        this.populateChest(point);
    }

    private boolean isSafe(@Nullable World world, WorldFeaturePoint point) {
        if (world == null) {
            return true;
        }
        Block block = world.getBlock(point.getX(), point.getY(), point.getZ());
        int blockID = block == null ? 0 : block.id();
        Material blockMaterial = blockID == 0 ? Material.air : block.getMaterial();
        return blockID == 0 || blockMaterial.isLiquid();
    }

    private void placeChest(WorldFeaturePoint point) {
        if (this.world == null) {
            return;
        }
        IntPair blockAndMeta = this.getTarget(this.world, point);
        this.world.setBlockAndMetadataWithNotify(point.getX(), point.getY(), point.getZ(), blockAndMeta.getFirst(), blockAndMeta.getSecond());
        BlockLogicRotatable.setDefaultDirection((World)this.world, (int)point.getX(), (int)point.getY(), (int)point.getZ());
        TileEntity tileEntity = this.world.getTileEntity(point.getX(), point.getY(), point.getZ());
        if (tileEntity instanceof TileEntityMimic) {
            ((TileEntityMimic)tileEntity).setCustomName(this.nickname, this.chatColor);
        }
    }

    private IntPair getTarget(World world, WorldFeaturePoint point) {
        WorldFeaturePoint next;
        int cdist;
        HashMap<WorldFeaturePoint, Integer> distance = new HashMap<WorldFeaturePoint, Integer>();
        ArrayDeque<WorldFeaturePoint> queue = new ArrayDeque<WorldFeaturePoint>();
        Direction[] check = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};
        queue.add(point);
        distance.put(point, 0);
        while (!queue.isEmpty() && (cdist = ((Integer)distance.get(next = (WorldFeaturePoint)queue.poll())).intValue()) < 5) {
            for (Direction direction : check) {
                BlockLogic blockLogic;
                WorldFeaturePoint to = new WorldFeaturePoint(next.getX() + direction.getOffsetX(), next.getY() + direction.getOffsetY(), next.getZ() + direction.getOffsetZ());
                if (distance.getOrDefault(to, -1) != -1) continue;
                distance.put(to, cdist + 1);
                Block block = world.getBlock(to.getX(), to.getY(), to.getZ());
                int metadata = world.getBlockMetadata(to.getX(), to.getY(), to.getZ());
                BlockLogic blockLogic2 = blockLogic = block == null ? null : block.getLogic();
                if (blockLogic instanceof BlockLogicChestMimic) {
                    return new IntPair(block.id(), metadata);
                }
                if (blockLogic instanceof BlockLogicChest) {
                    MimicEntry variant = MimicRegistry.getMimicVariantByChest(block.id(), metadata & 0xF0);
                    return new IntPair(variant.getMimicChestID(), variant.getMimicChestMetadata());
                }
                queue.add(to);
            }
        }
        MimicEntry variant = MimicRegistry.getMimicVariantByID(this.getSkinVariant());
        return new IntPair(variant.getMimicChestID(), variant.getMimicChestMetadata());
    }

    private void populateChest(WorldFeaturePoint point) {
        if (this.world == null) {
            return;
        }
        Container inventory = BlockLogicChest.getInventory((World)this.world, (int)point.getX(), (int)point.getY(), (int)point.getZ());
        if (inventory == null) {
            return;
        }
        List listLootObj = this.getMobDrops();
        for (WeightedRandomLootObject lootObj : listLootObj) {
            WorldFeatureComponent.placeItemInChest(this.random, lootObj.getDefinedItemStack(), inventory);
        }
    }

    public boolean isWallace() {
        MimicEntry variantWallace = MimicRegistry.getMimicVariantByChest(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), ((BlockLogicPaintedChest)AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.getLogic()).toMetadata(DyeColor.PURPLE));
        return "Wallace".equals(this.nickname) && variantWallace.getMimicVariant() == this.getSkinVariant();
    }

    @Override
    public boolean canSpawnHere() {
        return this.world != null && this.world.getDifficulty().canHostileMobsSpawn() && this.world.checkIfAABBIsClear(this.bb) && this.world.getCubes((Entity)this, this.bb).isEmpty();
    }
}

