/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.mimic;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

@Environment(value=EnvType.CLIENT)
public class ModelMimic
extends ModelBase {
    private final Cube box = new Cube(0, 19);
    private final Cube boxLid;
    private final Cube leftLeg;
    private final Cube rightLeg;

    public ModelMimic() {
        this.box.addBox(-4.0f, -5.0f, -4.0f, 8, 5, 8);
        this.boxLid = new Cube(12, 0);
        this.boxLid.addBox(-4.0f, -3.0f, -8.0f, 8, 3, 8);
        this.leftLeg = new Cube(0, 0);
        this.leftLeg.addBox(-1.5f, 0.0f, -1.5f, 3, 7, 3);
        this.rightLeg = new Cube(0, 0);
        this.rightLeg.addBox(-1.5f, 0.0f, -1.5f, 3, 7, 3);
        this.box.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.boxLid.setRotationPoint(0.0f, 12.0f, 4.0f);
        this.leftLeg.setRotationPoint(-2.0f, 17.0f, 0.0f);
        this.rightLeg.setRotationPoint(2.0f, 17.0f, 0.0f);
    }

    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.box.render(scale);
        this.boxLid.render(scale);
        this.rightLeg.render(scale);
        this.leftLeg.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.boxLid.xRot = -0.8f + MathHelper.cos((float)(limbSwing * 0.6662f)) * (limbYaw * 1.4f);
        this.rightLeg.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.1f * limbYaw;
        this.leftLeg.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.1f * limbYaw;
    }
}

