/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.valkyrie;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.MobPathfinder;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jspecify.annotations.NonNull;
import teamport.aether.AetherMod;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.MobUtil;
import teamport.aether.entity.player.MessageMaker;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.item.AetherItems;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobValkyrie
extends MobPathfinder
implements Enemy,
AetherDeathMessage {
    private static final int ATTACK_STRENGTH = 7;
    private boolean isSwinging;
    private int teleportTimer;
    private int chatTime;
    protected static float wingSpeed;

    public MobValkyrie(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"valkyrie");
        this.setSize(0.8f, 1.9f);
        this.mobDrops.add(new WeightedRandomLootObject(AetherItems.MEDAL_VICTORY.getDefaultStack(), 1));
        this.moveSpeed = 0.5f;
        this.scoreValue = 5000;
        this.footSize = 1.5f;
        this.canBreatheUnderwater();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public void jump() {
        this.yd = 0.72;
    }

    public void causeFallDamage(float distance) {
    }

    public void spawnInit() {
        this.teleportTimer = this.random.nextInt(250);
    }

    public void tick() {
        this.yo = this.yd;
        super.tick();
        if (!this.onGround && this.target != null && this.yo >= 0.0 && this.yd < 0.0 && this.distanceTo(this.target) <= 16.0f && this.canEntityBeSeen(this.target)) {
            double a = this.target.x - this.x;
            double b = this.target.z - this.z;
            double angle = Math.atan2(a, b);
            this.xd = Math.sin(angle) * 0.25;
            this.zd = Math.cos(angle) * 0.25;
        }
        if (!this.onGround && this.yd < 0.0) {
            this.yd += (double)0.055f;
            if (this.yd < (double)-0.275f) {
                this.yd = -0.275f;
            }
        }
        float f = this.moveSpeed = this.target == null ? 0.5f : 1.0f;
        if (this.world != null && !this.world.getDifficulty().canHostileMobsSpawn() && this.target != null) {
            this.target = null;
        }
        if (this.isSwinging) {
            this.prevSwingProgress += 0.15f;
            this.swingProgress += 0.15f;
            if (this.prevSwingProgress > 1.0f || this.swingProgress > 1.0f) {
                this.isSwinging = false;
                this.prevSwingProgress = 0.0f;
                this.swingProgress = 0.0f;
            }
        }
        wingSpeed = !this.onGround ? (wingSpeed += 0.75f) : (wingSpeed += 0.15f);
        if (wingSpeed > 6.283186f) {
            wingSpeed -= 6.283186f;
        }
    }

    public void teleport(double x, double y, double z, int rad) {
        int a = this.random.nextInt(rad + 1) * (this.random.nextInt(2) * 2 - 1);
        int b = this.random.nextInt(rad / 2) * (this.random.nextInt(2) * 2 - 1);
        int c = (rad - Math.abs(a)) * (this.random.nextInt(2) * 2 - 1);
        int newX = (int)Math.floor(x += (double)a);
        int newY = (int)Math.floor(y += (double)b);
        int newZ = (int)Math.floor(z += (double)c);
        boolean flag = false;
        int dungeonXMin = (int)(this.x - 10.0);
        int dungeonXMax = (int)(this.x + 10.0);
        int dungeonZMin = (int)(this.z - 10.0);
        int dungeonZMax = (int)(this.z + 10.0);
        for (int q = 0; q < 128 && !flag; ++q) {
            int i = newX + (this.random.nextInt(6) - this.random.nextInt(6));
            int j = (int)this.y;
            int k = newZ + (this.random.nextInt(6) - this.random.nextInt(6));
            if (j < 0 || j > 255 || !this.isAirySpace(i, j, k) || !this.isAirySpace(i, j + 1, k) || this.isAirySpace(i, j - 1, k) || i < dungeonXMin || i > dungeonXMax || k < dungeonZMin || k > dungeonZMax) continue;
            newX = i;
            newY = j;
            newZ = k;
            flag = true;
        }
        if (!flag) {
            this.teleportFailed();
        } else {
            if (!EnvironmentHelper.isServerEnvironment()) {
                ParticleMaker.spawnParticle(this.world, "explode", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
                ParticleMaker.spawnParticle(this.world, "smoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
                ParticleMaker.spawnParticle(this.world, "largesmoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
            }
            this.setPos((double)newX + 0.5, newY, (double)newZ + 0.5);
            if (this.world != null) {
                this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
            }
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            this.moveForward = 0.0f;
            this.moveStrafing = 0.0f;
            this.isJumping = false;
            this.xRot = 0.0f;
            this.yRot = 0.0f;
            this.setPathToEntity(null);
            this.yBodyRot = this.random.nextFloat() * 360.0f;
            this.teleportTimer = this.random.nextInt(40);
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        if (this.world == null) {
            return true;
        }
        int p = this.world.getBlockId(x, y, z);
        Block block = this.world.getBlock(x, y, z);
        Block blockTwo = Blocks.blocksList[p];
        return p == 0 || blockTwo == null || blockTwo.getCollisionBoundingBoxFromPool((WorldSource)this.world, x, y, z) == null || block != null && block.getMaterial() == Material.water;
    }

    public boolean interact(@NonNull Player entityplayer) {
        if (this.chatTime > 0 || this.target != null) {
            return false;
        }
        this.lookAt((Entity)entityplayer, 180.0f, 180.0f);
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.chatTime = 60;
        if (itemstack != null && itemstack.itemID == AetherItems.MEDAL_VICTORY.id && itemstack.stackSize >= 0) {
            StringBuilder formatString = new StringBuilder("valkyrie.show_medal.");
            if (itemstack.stackSize >= 10) {
                formatString.append(1);
            } else if (itemstack.stackSize >= 5) {
                formatString.append(2);
            } else {
                formatString.append(3);
            }
            String message = AetherMod.TRANSLATOR.translateKey(formatString.toString());
            MessageMaker.sendMessage(entityplayer, message);
        } else {
            int pokey = this.random.nextInt(3) + 1;
            String formatString = String.format("%s.%d", "valkyrie.interact", pokey);
            String message = AetherMod.TRANSLATOR.translateKey(formatString);
            MessageMaker.sendMessage(entityplayer, message);
        }
        if (this.world != null) {
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.talk", 1.0f, 1.0f);
        }
        return true;
    }

    public void updateAI() {
        super.updateAI();
        ++this.teleportTimer;
        if (this.target != null) {
            if (this.teleportTimer >= 250) {
                this.teleport(this.target.x, this.target.y, this.target.z, 4);
                this.remainingFireTicks = 0;
            } else if (this.teleportTimer % 5 == 0 && !this.canEntityBeSeen(this.target)) {
                this.teleportTimer += 50;
            }
        } else {
            this.teleportTimer = this.random.nextInt(40);
        }
        if (this.onGround && this.teleportTimer % 10 == 0) {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
        }
        if (this.target != null && !this.target.isAlive()) {
            this.target = null;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    public void swingArm() {
        if (!this.isSwinging) {
            this.isSwinging = true;
            this.prevSwingProgress = 0.0f;
            this.swingProgress = 0.0f;
        }
    }

    public void teleportFailed() {
        this.teleportTimer -= this.random.nextInt(40) + 40;
        if (this.y <= 0.0) {
            this.teleportTimer = 200;
        }
    }

    public boolean canSpawnHere() {
        int i = MathHelper.floor((double)this.x);
        int j = MathHelper.floor((double)this.bb.minY);
        int k = MathHelper.floor((double)this.z);
        return this.world != null && this.world.getFullBlockLightValue(i, j, k) > 8 && this.world.getIsAnySolidGround(this.bb) && this.world.getCollidingSolidBlockBoundingBoxes((Entity)this, this.bb).isEmpty() && !this.world.getIsAnyLiquid(this.bb);
    }

    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("teleportTimer", (short)this.teleportTimer);
    }

    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.teleportTimer = tag.getShort("teleportTimer");
    }

    public Entity findPlayerToAttack() {
        return this.world != null && this.world.getDifficulty().canHostileMobsSpawn() ? super.getTarget() : null;
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (attacker == null && type == null && damage == 100) {
            return MobUtil.killMob((Mob)this);
        }
        if (type == AetherMod.HOLY) {
            super.hurt(attacker, damage / 2, type);
        }
        if (attacker instanceof Player && this.world != null && this.world.getDifficulty().canHostileMobsSpawn()) {
            int pokey = this.random.nextInt(3) + 1;
            if (this.target == null && this.chatTime <= 0) {
                String formatString = String.format("%s.%d", "valkyrie.duel_start", pokey);
                String message = AetherMod.TRANSLATOR.translateKey(formatString);
                MessageMaker.sendMessage((Player)attacker, message);
                this.chatTime = 60;
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.talk", 1.0f, 1.0f);
            } else {
                this.teleportTimer += 25;
            }
            this.target = attacker;
            boolean flag = super.hurt(attacker, damage, type);
            if (flag && this.getHealth() <= 0) {
                this.dead = true;
                String formatString = String.format("%s.%d", "valkyrie.submit", pokey);
                String message = AetherMod.TRANSLATOR.translateKey(formatString);
                MessageMaker.sendMessage((Player)attacker, message);
                this.animateHurt();
            }
            return flag;
        }
        this.teleport(this.x, this.y, this.z, 4);
        this.remainingFireTicks = 0;
        if (this.world != null) {
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.laugh", 1.0f, 0.75f);
        }
        return false;
    }

    public void attackEntity(@NonNull Entity entity, float distance) {
        if (this.attackTime <= 0 && distance < 2.75f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            Player player;
            this.attackTime = 20;
            this.swingArm();
            entity.hurt((Entity)this, 7, AetherMod.HOLY);
            if (this.target != null && entity == this.target && entity instanceof Player && (player = (Player)entity).getHealth() <= 0) {
                int pokey = this.random.nextInt(3) + 1;
                String formatString = String.format("%s.%d", "valkyrie.attacked", pokey);
                String message = AetherMod.TRANSLATOR.translateKey(formatString);
                MessageMaker.sendMessage(player, message);
                if (this.world != null) {
                    this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.laugh", 1.0f, 1.0f);
                }
                this.target = null;
                this.chatTime = 0;
            }
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "aether:mob.valkyrie.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.valkyrie.death";
    }

    public int getMaxHealth() {
        return 50;
    }

    public ItemStack getHeldItem() {
        return new ItemStack(AetherItems.TOOL_SWORD_VALKYRIE, 1);
    }
}

