/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jspecify.annotations.NonNull;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import teamport.aether.AetherMod;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.effect.AetherEffects;
import teamport.aether.entity.monster.aechorplant.MobAechorPlant;
import teamport.aether.entity.monster.cockatrice.MobCockatrice;
import teamport.aether.entity.monster.zephyr.MobZephyr;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.item.AetherItems;

public class ProjectileDart
extends Projectile
implements ProjectileAether,
AetherProjectileDeathMessages {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int shake = 0;
    private int inData = 0;
    private final int dartType;
    private final ItemStack stack;
    private boolean inGround;
    private boolean doesDartBelongToPlayer;

    public ProjectileDart(World world) {
        this(world, 0);
    }

    public ProjectileDart(World world, int dartType) {
        super(world);
        if (dartType >= 2) {
            this.stack = new ItemStack(AetherItems.AMMO_DART_ENCHANTED);
            this.noPhysics = true;
            this.damage = 6;
        } else {
            this.stack = dartType == 1 ? new ItemStack(AetherItems.AMMO_DART_POISON) : new ItemStack(AetherItems.AMMO_DART_GOLDEN);
        }
        this.inGround = false;
        this.doesDartBelongToPlayer = false;
        this.dartType = dartType;
    }

    public ProjectileDart(World world, double d, double d1, double d2, int dartType) {
        super(world, d, d1, d2);
        if (dartType >= 2) {
            this.stack = new ItemStack(AetherItems.AMMO_DART_ENCHANTED);
            this.noPhysics = true;
            this.damage = 6;
        } else {
            this.stack = dartType == 1 ? new ItemStack(AetherItems.AMMO_DART_POISON) : new ItemStack(AetherItems.AMMO_DART_GOLDEN);
        }
        this.inGround = false;
        this.doesDartBelongToPlayer = false;
        this.dartType = dartType;
    }

    public ProjectileDart(World world, Mob mob, boolean doesDartBelongToPlayer, int dartType) {
        super(world, mob);
        if (dartType >= 2) {
            this.stack = new ItemStack(AetherItems.AMMO_DART_ENCHANTED);
            this.noPhysics = true;
            this.damage = 6;
        } else {
            this.stack = dartType == 1 ? new ItemStack(AetherItems.AMMO_DART_POISON) : new ItemStack(AetherItems.AMMO_DART_GOLDEN);
        }
        this.inGround = false;
        this.doesDartBelongToPlayer = false;
        this.setDoesDartBelongToPlayer(doesDartBelongToPlayer);
        this.dartType = dartType;
    }

    public void initProjectile() {
        super.initProjectile();
        this.damage = 4;
        this.defaultGravity = 0.005f;
        this.defaultProjectileSpeed = 1.0f;
    }

    public void setHeading(double newMotionX, double newMotionY, double newMotionZ, float speed, float randomness) {
        float velocity = MathHelper.sqrt((double)(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ));
        newMotionX /= (double)velocity;
        newMotionY /= (double)velocity;
        newMotionZ /= (double)velocity;
        if (this.dartType < 2) {
            newMotionX += this.random.nextGaussian() * 0.0075 * (double)randomness / 2.0;
            newMotionY += this.random.nextGaussian() * 0.0075 * (double)randomness / 2.0;
            newMotionZ += this.random.nextGaussian() * 0.0075 * (double)randomness / 2.0;
        } else {
            newMotionX += this.random.nextGaussian() * 0.0075 * (double)randomness / 4.0;
            newMotionY += this.random.nextGaussian() * 0.0075 * (double)randomness / 4.0;
            newMotionZ += this.random.nextGaussian() * 0.0075 * (double)randomness / 4.0;
        }
        this.xd = newMotionX *= (double)speed;
        this.yd = newMotionY *= (double)speed;
        this.zd = newMotionZ *= (double)speed;
        float f3 = MathHelper.sqrt((double)(newMotionX * newMotionX + newMotionZ * newMotionZ));
        this.yRotO = this.yRot = (float)(Math.atan2(newMotionX, newMotionZ) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(newMotionY, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void setDoesDartBelongToPlayer(boolean flag) {
        this.doesDartBelongToPlayer = flag;
    }

    public boolean dartBelongsToPlayer() {
        return this.doesDartBelongToPlayer;
    }

    public void setGrounded(boolean flag) {
        this.inGround = flag;
    }

    public boolean isGrounded() {
        return this.inGround;
    }

    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt((double)(xd * xd + zd * zd));
            this.yRot = (float)(Math.atan2(xd, zd) * 30.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(yd, f) * 30.0 / Math.PI);
            this.yRotO = this.yRot;
            this.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
            this.ticksInGround = 0;
        }
    }

    public void tick() {
        AABB aabb;
        Block block;
        if (this.world == null) {
            return;
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt((double)(this.xd * this.xd + this.zd * this.zd));
            this.yRotO = this.yRot = (float)(Math.atan2(this.xd, this.zd) * 30.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(this.yd, f) * 30.0 / Math.PI);
        }
        if ((block = this.world.getBlock(this.xTile, this.yTile, this.zTile)) != null && (aabb = block.getCollisionBoundingBoxFromPool((WorldSource)this.world, this.xTile, this.yTile, this.zTile)) != null && aabb.contains(Vec3.getTempVec3((double)this.x, (double)this.y, (double)this.z))) {
            this.setGrounded(true);
        }
        if (this.isGrounded()) {
            int id = this.world.getBlockId(this.xTile, this.yTile, this.zTile);
            int meta = this.world.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            if (id == this.inTile && meta == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.remove();
                }
            } else {
                this.setGrounded(false);
                this.xd *= (double)this.random.nextFloat() * 0.02;
                this.yd *= (double)this.random.nextFloat() * 0.02;
                this.zd *= (double)this.random.nextFloat() * 0.02;
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            if (this.dartType >= 2) {
                ParticleMaker.spawnParticle(this.world, "darttrail", this.x, this.y, this.z, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05, 0);
                ParticleMaker.spawnParticle(this.world, "darttrail", this.x + this.xd * 0.5, this.y + this.yd * 0.5, this.z + this.zd * 0.5, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05, 0);
            }
            super.tick();
        }
    }

    public HitResult getHitResult() {
        if (this.world == null) {
            super.getHitResult();
        }
        Vec3 oldPosition = Vec3.getTempVec3((double)this.x, (double)this.y, (double)this.z);
        Vec3 newPosition = Vec3.getTempVec3((double)(this.x + this.xd), (double)(this.y + this.yd), (double)(this.z + this.zd));
        return this.world.checkBlockCollisionBetweenPoints(oldPosition, newPosition, false, true, false);
    }

    public void onHit(HitResult hitResult) {
        if (this.world == null) {
            return;
        }
        if (hitResult.entity != null) {
            if (hitResult.entity instanceof MobZephyr) {
                hitResult.entity.hurt((Entity)this.owner, 10, DamageType.COMBAT);
                if (this.owner instanceof Player) {
                    ((Player)this.owner).addStat((Stat)AetherAchievements.HIT_ZEPHYR, 1);
                }
            }
            if (hitResult.entity.hurt((Entity)this.owner, this.damage, DamageType.COMBAT)) {
                if (this.dartType == 1 && hitResult.entity instanceof IHasEffects) {
                    AetherEffects.add(hitResult.entity, AetherEffects.poisonEffect, this.random.nextInt(1) + 1);
                }
                if (this.dartType >= 2) {
                    if (hitResult.entity instanceof MobCockatrice || hitResult.entity instanceof MobAechorPlant) {
                        hitResult.entity.hurt((Entity)this.owner, 12, AetherMod.HOLY);
                    }
                    if (hitResult.entity instanceof IHasEffects) {
                        IHasEffects entity = (IHasEffects)hitResult.entity;
                        AetherEffects.add(hitResult.entity, new EffectStack(entity, AetherEffects.remedyEffect, 40, 1));
                    }
                }
                if (this.isOnFire()) {
                    hitResult.entity.fireHurt();
                }
                if (!this.world.isClientSide) {
                    this.world.playSoundAtEntity(null, (Entity)this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                }
            } else if (this.dartType < 2) {
                this.defaultGravity = 0.03f;
                this.xd *= -0.1;
                this.yd *= -0.1;
                this.zd *= -0.1;
                this.yRot += 180.0f;
                this.yRotO += 180.0f;
                this.ticksInAir = 0;
            }
            this.remove();
        } else {
            this.xTile = hitResult.x;
            this.yTile = hitResult.y;
            this.zTile = hitResult.z;
            this.inTile = this.world.getBlockId(this.xTile, this.yTile, this.zTile);
            this.inData = this.world.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            this.xd = (float)(hitResult.location.x - this.x);
            this.yd = (float)(hitResult.location.y - this.y);
            this.zd = (float)(hitResult.location.z - this.z);
            float f1 = MathHelper.sqrt((double)(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd));
            this.x -= this.xd / (double)f1 * 0.05;
            this.y -= this.yd / (double)f1 * 0.05;
            this.z -= this.zd / (double)f1 * 0.05;
            this.inGroundAction();
        }
    }

    public void inGroundAction() {
        if (this.world == null) {
            return;
        }
        if (this.world.isClientSide) {
            this.setGrounded(true);
            this.shake = 3;
        } else if (this.dartBelongsToPlayer()) {
            this.world.playSoundAtEntity(null, (Entity)this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.setGrounded(true);
            this.shake = 3;
        } else {
            this.world.playSoundAtEntity(null, (Entity)this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            for (int j = 0; j < 4; ++j) {
                ParticleMaker.spawnParticle(this.world, "item", this.x, this.y, this.z, 0.0, 0.0, 0.0, AetherItems.AMMO_DART_GOLDEN.id);
            }
            this.remove();
        }
    }

    public void waterTick() {
        for (int k = 0; k < 4; ++k) {
            double particleDistance = 0.25;
            ParticleMaker.spawnParticle(this.world, "bubble", this.x - this.xd * particleDistance, this.y - this.yd * particleDistance, this.z - this.zd * particleDistance, this.xd, this.yd, this.zd, 0);
        }
        this.projectileSpeed = 0.95f;
    }

    public int getDartType() {
        return this.dartType;
    }

    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("xTile", (short)this.xTile);
        tag.putShort("yTile", (short)this.yTile);
        tag.putShort("zTile", (short)this.zTile);
        tag.putShort("inTile", (short)this.inTile);
        tag.putByte("shake", (byte)this.shake);
        tag.putByte("inData", (byte)this.inData);
        tag.putByte("inGround", (byte)(this.isGrounded() ? 1 : 0));
        tag.putBoolean("player", this.dartBelongsToPlayer());
    }

    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.xTile = tag.getShort("xTile");
        this.yTile = tag.getShort("yTile");
        this.zTile = tag.getShort("zTile");
        this.inTile = tag.getShort("inTile") & 0x3FFF;
        this.shake = tag.getByte("shake") & 0xFF;
        this.inData = tag.getByte("inData") & 0xFF;
        this.setGrounded(tag.getByte("inGround") == 1);
        this.setDoesDartBelongToPlayer(tag.getBoolean("player"));
    }

    public void playerTouch(Player player) {
        if (this.world == null || this.world.isClientSide) {
            return;
        }
        if (this.isGrounded() && this.dartBelongsToPlayer() && this.shake <= 0) {
            player.inventory.insertItem(this.stack, true);
            if (this.stack.stackSize <= 0) {
                this.world.playSoundAtEntity((Entity)player, (Entity)this, "item.pickup", 1.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 4.0f);
                player.onItemPickup((Entity)this, this.stack);
                this.remove();
            }
        }
    }

    @Override
    public PacketAddEntity getSpawnPacket(Projectile tracked) {
        return new PacketAddEntity((Entity)tracked, this.dartType, tracked.owner == null ? -1 : tracked.owner.id, Double.valueOf(tracked.xd), Double.valueOf(tracked.yd), Double.valueOf(tracked.zd));
    }

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        ProjectileDart projectile = new ProjectileDart(world, x, y, z, meta);
        if (hasVelocity) {
            projectile.setHeading(xd, yd, zd, 1.0f, 0.0f);
        }
        if (owner instanceof Mob) {
            projectile.owner = (Mob)owner;
        }
        if (owner instanceof Player) {
            projectile.doesDartBelongToPlayer = true;
        }
        return projectile;
    }

    public int getShake() {
        return this.shake;
    }
}

