/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.AetherJumpAmount;

@Environment(value=EnvType.CLIENT)
public class HudComponentJumpBar
extends HudComponentMovable {
    private static final IconCoordinate jump_full = TextureRegistry.getTexture((String)"aether:gui/hud/jump_full");
    private static final IconCoordinate jump_empty = TextureRegistry.getTexture((String)"aether:gui/hud/jump_empty");

    public HudComponentJumpBar(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    public boolean isVisible(Minecraft mc) {
        return mc.gameSettings.immersiveMode.drawHotbar() && mc.thePlayer.vehicle instanceof AetherJumpAmount;
    }

    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        if (!(mc.thePlayer.vehicle instanceof AetherJumpAmount)) {
            return;
        }
        int maxJumps = ((AetherJumpAmount)mc.thePlayer.vehicle).getJumpMaxAmount();
        int currentJumps = ((AetherJumpAmount)mc.thePlayer.vehicle).getJumpAmount();
        int baseX = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
        int baseY = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        for (int i = 0; i < maxJumps; ++i) {
            int row = i / 10;
            int column = i % 10;
            int x = baseX + column * 8;
            int y = baseY - row * 10;
            IconCoordinate icon = i < currentJumps ? jump_full : jump_empty;
            hud.drawGuiIcon(x, y, 9, 9, icon);
        }
    }

    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int screenWidth, int screenHeight) {
        int x = layout.getComponentX(mc, (HudComponent)this, screenWidth);
        int y = layout.getComponentY(mc, (HudComponent)this, screenHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        int previewFilled = 5;
        for (int i = 0; i < 10; ++i) {
            IconCoordinate icon = i < previewFilled ? jump_full : jump_empty;
            gui.drawGuiIcon(x + i * 8, y, 9, 9, icon);
        }
    }
}

