/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui.guidebook.enchanter;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.item.ItemStack;
import org.jspecify.annotations.NonNull;
import org.lwjgl.opengl.GL11;
import teamport.aether.gui.guidebook.AetherSlotGuidebook;
import teamport.aether.gui.guidebook.RecipePageAetherMachines;
import teamport.aether.recipe.RecipeEntryAetherMachine;

@Environment(value=EnvType.CLIENT)
public class RecipePageEnchanting
extends RecipePageAetherMachines {
    public RecipePageEnchanting(GuidebookSection section, List<RecipeEntryAetherMachine> recipes) {
        super(section, recipes);
    }

    @Override
    public void buildSlots(List<RecipeEntryAetherMachine> recipes) {
        for (RecipeEntryAetherMachine recipe : recipes) {
            ArrayList<AetherSlotGuidebook> recipeSlots = new ArrayList<AetherSlotGuidebook>();
            RecipeSymbol varietyItem = RecipePageEnchanting.getDamagedVariety(recipe);
            recipeSlots.add(new AetherSlotGuidebook(0, 47, 32 * (this.getMap().size() + 1) - 16, varietyItem, false, recipe));
            recipeSlots.add(new AetherSlotGuidebook(1, 103, 32 * (this.getMap().size() + 1) - 16, new RecipeSymbol((ItemStack)recipe.getOutput()), false, recipe));
            this.getMap().put(recipe, recipeSlots);
            this.getSlots().addAll(recipeSlots);
        }
    }

    @Override
    public void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryAetherMachine recipe = (RecipeEntryAetherMachine)((Object)this.recipes.get(i - 1));
            List<SlotGuidebook> list = this.getMap().get((Object)recipe);
            int posX = x + list.get((int)(list.size() - 1)).x - 32;
            int posY = y + list.get((int)(list.size() - 1)).y;
            this.drawTexturedModalRect(posX, posY, 234, 0, 22, 15);
            String timeString = RecipePageEnchanting.getTimeAsString((Integer)recipe.getData());
            int alignRight = timeString.length() > 2 ? -1 : 3;
            int adjY = 0;
            ItemStack input = ((RecipeSymbol)recipe.getInput()).getStack();
            ItemStack output = (ItemStack)recipe.getOutput();
            if (input != null && output != null && input.isItemStackDamageable() && output.isItemStackDamageable() && output.itemID == input.itemID) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)posX - 1.0f), (float)((float)posY - 1.0f), (float)0.0f);
                GL11.glScalef((float)0.85f, (float)0.93f, (float)1.0f);
                this.drawStringNoShadow(RecipePageEnchanting.mc.font, "max", 0, 0, -12566464);
                GL11.glPopMatrix();
                adjY = 11;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)posX + (float)alignRight), (float)((float)posY - 1.0f + (float)adjY), (float)0.0f);
            GL11.glScalef((float)0.85f, (float)0.93f, (float)1.0f);
            this.drawStringNoShadow(RecipePageEnchanting.mc.font, timeString, 0, 0, -12566464);
            GL11.glPopMatrix();
            re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static String getTimeAsString(int data) {
        StringBuilder buildTime = new StringBuilder();
        int time = Math.round((float)data / 20.0f);
        if (time >= 60) {
            time = Math.round((float)time / 60.0f);
            buildTime.append(time).append("m");
        } else {
            buildTime.append(time).append("s");
        }
        return buildTime.toString();
    }

    public static @NonNull RecipeSymbol getDamagedVariety(RecipeEntryAetherMachine recipe) {
        RecipeSymbol varientRecipeInput = (RecipeSymbol)recipe.getInput();
        ItemStack input = varientRecipeInput.getStack();
        ItemStack copyInput = ItemStack.copyItemStack((ItemStack)input);
        ItemStack output = (ItemStack)recipe.getOutput();
        if (copyInput != null && output != null && copyInput.isItemStackDamageable() && output.isItemStackDamageable() && output.itemID == copyInput.itemID) {
            ArrayList<ItemStack> variations = new ArrayList<ItemStack>();
            for (int i = 1; i < 10; ++i) {
                int damage = Math.round((float)copyInput.getMaxDamage() / 10.0f * (float)i);
                copyInput.setMetadata(damage);
                ItemStack stack = copyInput.copy();
                variations.add(stack);
            }
            varientRecipeInput = new RecipeSymbol(variations);
        }
        return varientRecipeInput;
    }
}

