/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui.machine.freezer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import teamport.aether.AetherRecipes;
import teamport.aether.block.entity.TileEntityFreezer;
import teamport.aether.gui.machine.ScreenAetherMachine;
import teamport.aether.gui.machine.freezer.MenuFreezer;
import teamport.aether.lookup.LookupFuelFreezer;

@Environment(value=EnvType.CLIENT)
public class ScreenFreezer
extends ScreenAetherMachine {
    private final TileEntityFreezer freezer;

    public ScreenFreezer(ContainerInventory inventory, TileEntityFreezer tileEntityFreezer) {
        super(new MenuFreezer(inventory, tileEntityFreezer));
        this.freezer = tileEntityFreezer;
    }

    public void drawGuiContainerBackgroundLayer(float f) {
        this.mc.textureManager.loadTexture("/assets/aether/textures/gui/container/freezer.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        if (this.freezer.isProcessing()) {
            int fireHeight = this.freezer.getEnergyTimeRemainingScaled(12);
            this.drawTexturedModalRect(j + 56, k + 36 + 12 - fireHeight, 176, 12 - fireHeight, 14, fireHeight + 2);
            int arrowWidth = this.freezer.getProcessProgressScaled(24);
            this.drawTexturedModalRect(j + 79, k + 34, 176, 14, arrowWidth + 1, 16);
        }
    }

    public void drawGuiContainerForegroundLayer() {
        I18n i18n = I18n.getInstance();
        this.font.drawString(i18n.translateKey("aether.gui.freezer.title"), 60, 6, -12566464);
        this.font.drawString(i18n.translateKey("gui.furnace.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    public int getTargetSlot(ItemStack stackInSlot, int clickedItemId) {
        boolean isFuel;
        boolean isIngredient = AetherRecipes.FREEZER.findRecipe(stackInSlot) != null;
        boolean bl = isFuel = LookupFuelFreezer.INSTANCE.getFuelYield(clickedItemId) > 0;
        if (isIngredient) {
            return 1;
        }
        if (isFuel) {
            return 2;
        }
        return 0;
    }
}

