/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.helper;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;
import teamport.aether.AetherMod;
import teamport.aether.entity.player.ContainerHelper;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.item.AetherArmorMaterial;
import teamport.aether.mixin.accessors.EntityAccessor;

public class MixinHelper {
    public static final int ANIMATION_LENGTH = 30;
    public static final Map<Integer, Integer> BLOCK_TO_BECOME = new HashMap<Integer, Integer>();

    private MixinHelper() {
    }

    public static int fireResistanceCount(ContainerInventory inventory) {
        return ContainerHelper.countArmorPiecesOfMaterial(inventory, AetherArmorMaterial.PHOENIX);
    }

    public static void damageArmourWithEffect(int damage, Player player, double x, double y, double z, float bbHeight, float bbWidth) {
        if ((double)((EntityAccessor)player).getRandom().nextFloat() < (double)0.05f) {
            player.inventory.damageArmor(damage);
            if (((EntityAccessor)player).getRandom().nextInt(6) == 0 && player.world != null) {
                player.world.playSoundAtEntity(null, (Entity)player, "random.fizz", 0.5f, 0.8f / (((EntityAccessor)player).getRandom().nextFloat() * 0.2f + 0.9f));
            }
        }
        ParticleMaker.spawnSmokeParticles(player.world, x, y, z, bbHeight, bbWidth);
    }

    public static boolean isImmuneToFire(MobWolf mobWolf) {
        ArmorMaterial armorMaterial = mobWolf.getArmorMaterial();
        if (armorMaterial == null) {
            return false;
        }
        return armorMaterial.equals(AetherArmorMaterial.PHOENIX);
    }

    public static boolean isBrokenAABB(AABB aabb) {
        double diffX = Math.abs(aabb.maxX - aabb.minX);
        double diffY = Math.abs(aabb.maxY - aabb.minY);
        double diffZ = Math.abs(aabb.maxZ - aabb.minZ);
        return diffX > 1000000.0 || diffY > 1000000.0 || diffZ > 1000000.0 || Double.isNaN(diffX) || Double.isNaN(diffY) || Double.isNaN(diffZ);
    }

    public static <T> List<T> preventStupidShit(World world, Class<T> ofClass, Entity entity, AABB aabb, Operation<List<T>> original) {
        if (MixinHelper.isBrokenAABB(aabb)) {
            if (entity != null) {
                Block block;
                if (AetherMod.LOGGER.isErrorEnabled()) {
                    AetherMod.LOGGER.error("{} is moving too fast. Entity at {} {} {} with speed {}! Please send this to a developer!", new Object[]{Entity.getNameFromEntity((Entity)entity, (boolean)true), entity.x, entity.y, entity.z, Math.sqrt(entity.xd * entity.xd + entity.yd * entity.yd + entity.zd * entity.zd)});
                }
                String name = (block = world.getBlock((int)Math.round(entity.x), (int)Math.round(entity.y - 1.0), (int)Math.round(entity.z))) == null ? "air" : block.getLanguageKey(0);
                AetherMod.LOGGER.error("Currently standing on: {} at ", (Object)name);
                AetherMod.LOGGER.error("Please send this log to a BWA developer!");
                Thread.dumpStack();
                entity.absMoveTo(0.0, 255.0, 0.0, 0.0f, 0.0f);
                entity.xo = 0.0;
                entity.yo = 0.0;
                entity.zo = 0.0;
            } else {
                AetherMod.LOGGER.error("Something is moving too fast! Please send this to a developer!");
                Thread.dumpStack();
            }
            return new ArrayList();
        }
        return entity != null ? (List)original.call(new Object[]{entity, aabb}) : (List)original.call(new Object[]{ofClass, aabb});
    }

    public static void renderShieldVignette(TextureManager textureManager, int xSize, int ySize) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        textureManager.loadTexture("/assets/aether/textures/other/shieldvignette.png").bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, (double)ySize, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)xSize, (double)ySize, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV((double)xSize, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int mixColor(int colorA, int colorB, float ratio) {
        int alphaA = Color.alphaFromInt((int)colorA);
        int redA = Color.redFromInt((int)colorA);
        int blueA = Color.blueFromInt((int)colorA);
        int greenA = Color.greenFromInt((int)colorA);
        int alphaB = Color.alphaFromInt((int)colorB);
        int redB = Color.redFromInt((int)colorB);
        int blueB = Color.blueFromInt((int)colorB);
        int greenB = Color.greenFromInt((int)colorB);
        int alphaRes = (int)((float)alphaA * ratio + (float)alphaB * (1.0f - ratio));
        int redRes = (int)((float)redA * ratio + (float)redB * (1.0f - ratio));
        int blueRes = (int)((float)blueA * ratio + (float)blueB * (1.0f - ratio));
        int greenRes = (int)((float)greenA * ratio + (float)greenB * (1.0f - ratio));
        return Color.intToIntARGB((int)alphaRes, (int)redRes, (int)blueRes, (int)greenRes);
    }

    static {
        BLOCK_TO_BECOME.put(Blocks.PUMPKIN_CARVED_ACTIVE.id(), Blocks.PUMPKIN_CARVED_IDLE.id());
        BLOCK_TO_BECOME.put(Blocks.BRAZIER_ACTIVE.id(), Blocks.BRAZIER_INACTIVE.id());
        BLOCK_TO_BECOME.put(Blocks.PUMICE_WET.id(), Blocks.PUMICE_DRY.id());
        BLOCK_TO_BECOME.put(Blocks.COBBLE_NETHERRACK_IGNEOUS.id(), Blocks.COBBLE_NETHERRACK.id());
    }
}

