/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemDoorDungeon
extends Item {
    private final Block<?> doorBlock;
    private final DoorType doorType;

    public ItemDoorDungeon(String name, String namespaceId, int id, Block<?> doorBlock, DoorType doorType) {
        super(name, namespaceId, id);
        this.doorBlock = doorBlock;
        this.doorType = doorType;
    }

    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int placeZ;
        int placeX;
        int w;
        int y;
        int zOffset;
        int xOffset;
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        int width = this.doorType.width;
        int height = this.doorType.height;
        Direction dir = entityplayer.getHorizontalPlacementDirection(side).rotate(2);
        int meta = dir.getHorizontalIndex();
        switch (dir) {
            case NORTH: {
                xOffset = -1;
                zOffset = 0;
                break;
            }
            case SOUTH: {
                xOffset = 1;
                zOffset = 0;
                break;
            }
            case EAST: {
                xOffset = 0;
                zOffset = -1;
                break;
            }
            case WEST: {
                xOffset = 0;
                zOffset = 1;
                break;
            }
            default: {
                return false;
            }
        }
        for (y = 0; y < height; ++y) {
            for (w = 0; w < width; ++w) {
                placeX = blockX + w * xOffset;
                placeZ = blockZ + w * zOffset;
                if (this.doorBlock.canPlaceBlockAt(world, placeX, blockY + y, placeZ)) continue;
                return false;
            }
        }
        world.noNeighborUpdate = true;
        for (y = 0; y < height; ++y) {
            for (w = 0; w < width; ++w) {
                placeX = blockX + w * xOffset;
                placeZ = blockZ + w * zOffset;
                world.setBlockAndMetadataWithNotify(placeX, blockY + y, placeZ, this.doorBlock.id(), meta);
                world.notifyBlocksOfNeighborChange(placeX, blockY + y, placeZ, this.doorBlock.id());
                this.doorBlock.onBlockPlacedByMob(world, placeX, blockY + y, placeZ, side, (Mob)entityplayer, xPlaced, yPlaced);
            }
        }
        world.noNeighborUpdate = false;
        world.playBlockSoundEffect((Entity)entityplayer, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), this.doorBlock, EnumBlockSoundEffectType.PLACE);
        itemstack.consumeItem(entityplayer);
        return true;
    }

    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int placeZ;
        int placeX;
        int w;
        int y;
        int zOffset;
        int xOffset;
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += direction.getOffsetX();
            blockY += direction.getOffsetY();
            blockZ += direction.getOffsetZ();
        }
        int width = this.doorType.width;
        int height = this.doorType.height;
        if (!direction.isHorizontal()) {
            direction = Direction.NORTH;
        }
        Direction dir = direction.rotate(2);
        int meta = dir.getHorizontalIndex();
        switch (dir) {
            case NORTH: {
                xOffset = -1;
                zOffset = 0;
                break;
            }
            case SOUTH: {
                xOffset = 1;
                zOffset = 0;
                break;
            }
            case EAST: {
                xOffset = 0;
                zOffset = -1;
                break;
            }
            case WEST: {
                xOffset = 0;
                zOffset = 1;
                break;
            }
            default: {
                return;
            }
        }
        for (y = 0; y < height; ++y) {
            for (w = 0; w < width; ++w) {
                placeX = blockX + w * xOffset;
                placeZ = blockZ + w * zOffset;
                if (this.doorBlock.canPlaceBlockAt(world, placeX, blockY + y, placeZ)) continue;
                return;
            }
        }
        world.noNeighborUpdate = true;
        for (y = 0; y < height; ++y) {
            for (w = 0; w < width; ++w) {
                placeX = blockX + w * xOffset;
                placeZ = blockZ + w * zOffset;
                world.setBlockAndMetadataWithNotify(placeX, blockY + y, placeZ, this.doorBlock.id(), meta);
                world.notifyBlocksOfNeighborChange(placeX, blockY + y, placeZ, this.doorBlock.id());
                this.doorBlock.onBlockPlacedOnSide(world, placeX, blockY + y, placeZ, direction.getSide(), 0.5, 0.5);
            }
        }
        world.noNeighborUpdate = false;
        world.playBlockSoundEffect(null, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), this.doorBlock, EnumBlockSoundEffectType.PLACE);
        itemStack.consumeItem(null);
    }

    public static enum DoorType {
        BRONZE(4, 4),
        SILVER(2, 3),
        GOLD(3, 3);

        private final int width;
        private final int height;

        private DoorType(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

