/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import teamport.aether.entity.projectile.ProjectileWindball;

public class ItemStaffCloud
extends Item {
    public ItemStaffCloud(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(192);
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        world.playSoundAtEntity((Entity)entityplayer, (Entity)entityplayer, "aether:mob.zephyr.shoot", 0.3f, 1.0f / (itemRand.nextFloat() * -0.2f - 0.4f));
        if (!world.isClientSide) {
            double lookX = entityplayer.getLookAngle().x;
            double lookY = entityplayer.getLookAngle().y;
            double lookZ = entityplayer.getLookAngle().z;
            double perpX = -lookZ;
            double perpZ = lookX;
            double length = Math.sqrt(perpX * perpX + perpZ * perpZ);
            if (length > 0.0) {
                perpX /= length;
                perpZ /= length;
            } else {
                perpX = 1.0;
                perpZ = 0.0;
            }
            ProjectileWindball windballLeft = new ProjectileWindball(world);
            windballLeft.setPos(entityplayer.x + perpX, entityplayer.y, entityplayer.z + perpZ);
            windballLeft.setHeading(lookX, lookY, lookZ, 1.0f, 0.0f);
            world.entityJoinedWorld((Entity)windballLeft);
            ProjectileWindball windballRight = new ProjectileWindball(world);
            windballRight.setPos(entityplayer.x - perpX, entityplayer.y, entityplayer.z - perpZ);
            windballRight.setHeading(lookX, lookY, lookZ, 1.0f, 0.0f);
            world.entityJoinedWorld((Entity)windballRight);
            itemstack.damageItem(1, (Entity)entityplayer);
        }
        return itemstack;
    }
}

