/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item.accessory;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.DamageType;
import teamport.aether.item.AetherHasCustomDamageType;
import teamport.aether.item.accessory.ItemAccessoryArmor;

public class ItemGloves
extends ItemAccessoryArmor
implements IArmorItem,
AetherHasCustomDamageType {
    private final ArmorMaterial material;
    private int damage;
    private DamageType damageType;

    public ItemGloves(String translationKey, String namespaceId, int id, ArmorMaterial material, int accessoryPiece) {
        super(translationKey, namespaceId, id, material.identifier.value(), accessoryPiece);
        this.material = material;
        float maxDurability = IArmorItem.ARMOR_PIECE_DURABILITY_MODIFIERS[3] * (float)material.durability;
        this.setMaxDamage((int)Math.ceil(maxDurability));
        this.damageType = DamageType.COMBAT;
    }

    public ItemGloves setDamageType(DamageType damageType) {
        this.damageType = damageType;
        return this;
    }

    public ItemGloves setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    @Override
    public DamageType getDamageType() {
        return this.damageType;
    }

    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public int armorPieceProtection() {
        return 3;
    }

    public float getArmorPieceProtectionPercentage() {
        return (float)this.armorPieceProtection() / 40.0f;
    }

    public int getArmorPiece() {
        return this.getSlotID();
    }

    public boolean hitEntity(ItemStack gloves, Mob target, Mob attacker) {
        if (!(attacker instanceof Player)) {
            return super.hitEntity(gloves, target, attacker);
        }
        Player player = (Player)attacker;
        ItemStack hold = player.getHeldItem();
        if (hold == null && gloves != null && gloves.getItem() instanceof ItemGloves) {
            gloves.damageItem(1, (Entity)attacker);
            return true;
        }
        return false;
    }

    public int getDamage() {
        return this.damage;
    }
}

