/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item.accessory.pendant;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import teamport.aether.item.accessory.pendant.ItemPendant;

public class ItemIcePendant
extends ItemPendant {
    public ItemIcePendant(String translationKey, String namespaceId, int id, String name) {
        super(translationKey, namespaceId, id, name, ArmorMaterial.IRON);
    }

    public void inventoryTick(ItemStack stack, World world, Entity entity, int slotId, boolean flag) {
        Vec3 playerNextPos;
        Player player = (Player)entity;
        if (slotId < player.inventory.mainInventory.length || slotId - player.inventory.mainInventory.length < 6 || player.isInWater() || player.isSneaking()) {
            return;
        }
        Vec3 playerPos = Vec3.getPermanentVec3((double)player.x, (double)(player.y - (double)player.bbHeight), (double)player.z);
        HitResult hits = world.checkBlockCollisionBetweenPoints(playerPos, playerNextPos = Vec3.getPermanentVec3((double)(player.x + player.xd), (double)(player.y - (double)player.bbHeight + player.yd - 1.0), (double)(player.z + player.zd)), true);
        if (hits == null || hits.hitType == HitResult.HitType.ENTITY) {
            return;
        }
        int x = MathHelper.ceil((double)hits.x);
        int y = MathHelper.ceil((double)hits.y);
        int z = MathHelper.ceil((double)hits.z);
        int proc = 0;
        for (int radius = -1; radius <= 1; ++radius) {
            for (int depth = -1; depth <= 1; ++depth) {
                int xPos = x + radius;
                int zPos = z + depth;
                Material material = world.getBlockMaterial(xPos, y, zPos);
                if (material == Material.water) {
                    ++proc;
                    world.setBlockWithNotify(xPos, y, zPos, Blocks.ICE.id());
                    continue;
                }
                if (material != Material.lava) continue;
                ++proc;
                world.setBlockWithNotify(xPos, y, zPos, Blocks.OBSIDIAN.id());
            }
        }
        if (proc > 0) {
            this.damagePendant(stack, player);
        }
    }

    private void damagePendant(ItemStack stack, Player player) {
        stack.damageItem(1, (Entity)player);
        if (player.inventory.armorInventory[6] == stack && stack.stackSize <= 0) {
            player.inventory.armorInventory[6] = null;
            return;
        }
        if (player.inventory.armorInventory[7] == stack && stack.stackSize <= 0) {
            player.inventory.armorInventory[7] = null;
        }
    }
}

