/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item.accessory.pendant;

import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.material.ArmorMaterial;
import org.jspecify.annotations.Nullable;
import teamport.aether.item.AetherItemTags;
import teamport.aether.item.accessory.IAccessory;

public class ItemPendant
extends Item
implements IAccessory,
IArmorItem {
    private final String name;
    private final ArmorMaterial material;
    private boolean canHarvestDamage;

    public ItemPendant(String translationKey, String namespaceId, int id, String name, ArmorMaterial material) {
        super(translationKey, namespaceId, id);
        this.name = name;
        this.maxStackSize = 1;
        this.material = material;
        float maxDurability = IArmorItem.ARMOR_PIECE_DURABILITY_MODIFIERS[3] * (float)material.durability;
        this.setMaxDamage((int)Math.ceil(maxDurability));
        this.withTags(AetherItemTags.tags(AetherItemTags.TRINKET));
        this.canHarvestDamage = false;
    }

    public ItemPendant(String translationKey, String namespaceId, int id, ArmorMaterial material) {
        this(translationKey, namespaceId, id, material.identifier.value(), material);
    }

    @Override
    public String name() {
        return this.name;
    }

    public @Nullable ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public int armorPieceProtection() {
        return 0;
    }

    public int getArmorPiece() {
        return -1;
    }

    public ItemPendant setHarvestDamagable() {
        this.canHarvestDamage = true;
        return this;
    }

    public boolean canHarvestDamage() {
        return this.canHarvestDamage;
    }
}

