/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item.item_tool;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import redart15.commandly.veincapitator.VeinMining;
import teamport.aether.block.AetherBlockTags;
import teamport.aether.block.AetherBlocks;
import teamport.aether.compat.commandly.AetherCommandlyRules;
import teamport.aether.entity.player.PlayerUntil;

public class ItemToolPickaxeAether
extends ItemTool {
    protected static final Map<Block<?>, Integer> MINING_LEVELS = new HashMap();

    public ItemToolPickaxeAether(String name, String namespaceId, int id, ToolMaterial enumtoolmaterial) {
        super(name, namespaceId, id, 2, enumtoolmaterial, AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE);
    }

    public boolean canHarvestBlock(Mob mob, ItemStack itemStack, Block<?> block) {
        Integer miningLevel = MINING_LEVELS.get(block);
        if (miningLevel != null) {
            return this.material.getMiningLevel() >= miningLevel;
        }
        return block.hasTag(AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE);
    }

    public boolean beforeDestroyBlock(World world, ItemStack itemStack, int blockId, int x, int y, int z, Side side, Player player) {
        if (!world.isClientSide && AetherCommandlyRules.canVeinMine(world) && !player.isSneaking()) {
            return !VeinMining.veinMining((World)world, (ItemStack)itemStack, (int)x, (int)y, (int)z, (Player)player).setDropCause(PlayerUntil.isSilkTouch(player) ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL).setMiningTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE}).mine(blockId, side);
        }
        return true;
    }

    static {
        MINING_LEVELS.put(AetherBlocks.ICESTONE, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_STONE, 1);
        MINING_LEVELS.put(AetherBlocks.SLAB_CARVED_STONE, 1);
        MINING_LEVELS.put(AetherBlocks.STAIRS_CARVED_STONE, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_STONE_LIGHT, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_DUNGEON_BRONZE, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_MIMIC_BRONZE, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_STONE_TRAPPED, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_ANGELIC, 1);
        MINING_LEVELS.put(AetherBlocks.SLAB_CARVED_ANGELIC, 1);
        MINING_LEVELS.put(AetherBlocks.STAIRS_CARVED_ANGELIC, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_ANGELIC_LIGHT, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_DUNGEON_SILVER, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_MIMIC_SILVER, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_HELLFIRE, 1);
        MINING_LEVELS.put(AetherBlocks.SLAB_CARVED_HELLFIRE, 1);
        MINING_LEVELS.put(AetherBlocks.STAIRS_CARVED_HELLFIRE, 1);
        MINING_LEVELS.put(AetherBlocks.CARVED_HELLFIRE_LIGHT, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_DUNGEON_GOLD, 1);
        MINING_LEVELS.put(AetherBlocks.CHEST_MIMIC_GOLD, 1);
        MINING_LEVELS.put(AetherBlocks.PILLAR, 1);
        MINING_LEVELS.put(AetherBlocks.PILLAR_CAPSTONE, 1);
        MINING_LEVELS.put(AetherBlocks.BLOCK_ZANITE, 1);
        MINING_LEVELS.put(AetherBlocks.ORE_ZANITE_HOLYSTONE, 1);
        MINING_LEVELS.put(AetherBlocks.BRICK_ZANITE, 1);
        MINING_LEVELS.put(AetherBlocks.SLAB_BRICK_ZANITE, 1);
        MINING_LEVELS.put(AetherBlocks.STAIRS_BRICK_ZANITE, 1);
        MINING_LEVELS.put(AetherBlocks.BLOCK_GRAVITITE, 2);
        MINING_LEVELS.put(AetherBlocks.ORE_GRAVITITE_HOLYSTONE, 2);
        MINING_LEVELS.put(AetherBlocks.AEROGEL, 3);
    }
}

