/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.item.item_tool.item_tool_gravitite;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import teamport.aether.block.AetherBlockTags;
import teamport.aether.entity.MobUtil;
import teamport.aether.entity.floating_block.EntityFloatingBlock;
import teamport.aether.item.AetherHasCustomDamageType;
import teamport.aether.item.item_tool.ItemToolAxeAether;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class ItemToolAxeGravitite
extends ItemToolAxeAether
implements AetherHasCustomDamageType {
    private static final float KNOCKBACK_STRENGTH = 0.75f;
    private static final float LIFT = 0.75f;

    public ItemToolAxeGravitite(String name, String namespaceId, int id, ToolMaterial enumtoolmaterial) {
        super(name, namespaceId, id, enumtoolmaterial);
    }

    public boolean onUseItemOnBlock(ItemStack itemstack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Block block = world.getBlock(blockX, blockY, blockZ);
        Block nextBlock = world.getBlock(blockX, blockY + 1, blockZ);
        if (block == null || !block.hasTag(AetherBlockTags.MINEABLE_BY_AETHER_AXE) || !player.isSneaking() || block.getHardness() < 0.0f || nextBlock != null && nextBlock.id() != Blocks.COBWEB.id() && !nextBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            return false;
        }
        if (EnvironmentHelper.isClientWorld()) {
            return true;
        }
        TileEntity tileEntity = world.getTileEntity(blockX, blockY, blockZ);
        int metadata = world.getBlockMetadata(blockX, blockY, blockZ);
        world.removeBlockTileEntity(blockX, blockY, blockZ);
        world.setBlockWithNotify(blockX, blockY, blockZ, 0);
        EntityFloatingBlock entityFloatingBlock = new EntityFloatingBlock(world, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, block.id(), metadata, tileEntity);
        entityFloatingBlock.setHasRemovedBlock(true);
        world.entityJoinedWorld((Entity)entityFloatingBlock);
        itemstack.damageItem(1, (Entity)player);
        return true;
    }

    public boolean hitEntity(ItemStack itemstack, Mob target, Mob attacker) {
        if (target instanceof Mob && target.hurtTime == 10) {
            if (attacker.isSneaking() && attacker instanceof Player) {
                MobUtil.knockback((Entity)target, (Entity)attacker, 0.75f, 0.4f);
            } else {
                MobUtil.knockback((Entity)target, (Entity)attacker, 0.4f, 0.75f);
            }
        }
        return super.hitEntity(itemstack, target, attacker);
    }

    @Override
    public DamageType getDamageType() {
        return DamageType.FALL;
    }
}

