/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionRange;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.option.AetherGameSettingsOptions;

@Environment(value=EnvType.CLIENT)
@Mixin(value={GameSettings.class}, remap=false)
public abstract class GameSettingsMixin
implements AetherGameSettingsOptions {
    @Shadow
    @Final
    public Minecraft mc;
    @Unique
    private final OptionRange flickAccessorySpeed = new OptionRange((GameSettings)this, "aether.flickAccessorySpeed", 5, 0, 60);

    @Override
    public OptionRange aether$getAccessoryFlickSpeed() {
        return this.flickAccessorySpeed;
    }

    @ModifyReturnValue(method={"getDisplayString"}, at={@At(value="RETURN")})
    private String changeDisplayString(String original, Option<?> option) {
        if (option == null) {
            return "";
        }
        if (option == this.flickAccessorySpeed) {
            int speed = Integer.parseInt(option.value.toString());
            if (speed == 0) {
                return "OFF";
            }
            return option.value + " seconds";
        }
        return original;
    }
}

