/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import org.jspecify.annotations.NonNull;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.helper.GLManager;
import teamport.aether.item.AetherRepulsion;
import teamport.aether.item.accessory.AetherInvisibility;
import teamport.aether.item.accessory.IAccessory;
import teamport.aether.item.accessory.ItemGloves;
import teamport.aether.item.accessory.pendant.ItemPendant;
import teamport.aether.item.accessory.trinket.ItemGoldenFeather;
import teamport.aether.item.accessory.trinket.ItemIronBubble;
import teamport.aether.item.accessory.trinket.ItemRegenStone;
import teamport.aether.item.accessory.trinket.ItemRepulsionShield;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MobRendererPlayer.class}, remap=false)
public abstract class MobRendererPlayerMixinAccessoryRender
extends MobRenderer<Player> {
    @Shadow
    private ModelBiped modelBipedMain;
    @Shadow
    @Final
    private ModelBiped modelArmor;
    @Shadow
    @Final
    private ModelBiped modelArmorChestplate;
    @Unique
    private final ModelBiped modelAccessories = new ModelBiped(1.1f);
    @Unique
    private final ModelBiped modelHeart = new ModelBiped(1.0f);
    @Unique
    private final ModelBiped modelBubble = new ModelBiped(1.0f);
    @Unique
    private final ModelBiped modelFeather = new ModelBiped(1.0f);
    @Unique
    private final ModelBiped shield = new ModelBiped(1.5f);
    @Unique
    private boolean shield6 = false;

    protected MobRendererPlayerMixinAccessoryRender(ModelBase model, float shadowSize) {
        super(model, shadowSize);
    }

    @Inject(method={"drawFirstPersonHand"}, at={@At(value="TAIL")})
    private void callDrawFirstPersonHandAfter(@NonNull Player player, boolean isLeft, CallbackInfo ci) {
        ItemStack itemStack = player.inventory.armorInventory[4];
        if (itemStack != null && itemStack.getItem() instanceof ItemGloves) {
            Item item = itemStack.getItem();
            String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
            if (this.renderDispatcher.textureManager == null) {
                return;
            }
            this.renderDispatcher.textureManager.loadTexture(path).bind();
            TextureManager textureManager = this.renderDispatcher.textureManager;
            if (textureManager == null) {
                return;
            }
            int currentTexture = GL11.glGetInteger((int)32873);
            textureManager.loadTexture(path).bind();
            GL11.glDisable((int)2884);
            this.modelArmorChestplate.onGround = 0.0f;
            this.modelArmorChestplate.isRiding = false;
            this.modelArmorChestplate.setupAnimation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (isLeft) {
                this.modelArmorChestplate.armLeft.visible = true;
                this.modelArmorChestplate.armLeft.render(0.0625f);
            } else {
                this.modelArmorChestplate.armRight.visible = true;
                this.modelArmorChestplate.armRight.render(0.0625f);
            }
            GL11.glBindTexture((int)3553, (int)currentTexture);
        }
    }

    @ModifyExpressionValue(method={"prepareArmor(Lnet/minecraft/core/entity/player/Player;IF)Z"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=4)})
    @Definition(id="spectator", field={"Lnet/minecraft/core/player/gamemode/Gamemode;spectator:Lnet/minecraft/core/player/gamemode/Gamemode;"})
    @Expression(value={"spectator"})
    private Gamemode renderPlayerOne(Gamemode original, Player entity, int layer, float partialTick) {
        if (((AetherInvisibility)entity).aether$isInvisible()) {
            return entity.getGamemode();
        }
        return original;
    }

    @WrapOperation(method={"prepareArmor(Lnet/minecraft/core/entity/player/Player;IF)Z"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glColor4f(FFFF)V", ordinal=1)})
    private void renderPlayerTwo(float red, float blue, float green, float alpha, Operation<Void> original, Player entity, int layer, float partialTick) {
        if (entity.getGamemode() == Gamemode.spectator) {
            original.call(new Object[]{Float.valueOf(red), Float.valueOf(blue), Float.valueOf(green), Float.valueOf(alpha)});
            return;
        }
        original.call(new Object[]{Float.valueOf(red), Float.valueOf(blue), Float.valueOf(green), Float.valueOf(0.05f)});
        GL11.glEnable((int)3042);
    }

    @ModifyExpressionValue(method={"setupScale(Lnet/minecraft/core/entity/player/Player;F)V"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=2)})
    @Definition(id="spectator", field={"Lnet/minecraft/core/player/gamemode/Gamemode;spectator:Lnet/minecraft/core/player/gamemode/Gamemode;"})
    @Expression(value={"spectator"})
    private Gamemode renderPlayerThree(Gamemode original, Player entity, float partialTick) {
        if (((AetherInvisibility)entity).aether$isInvisible()) {
            return entity.getGamemode();
        }
        return original;
    }

    @WrapOperation(method={"setupScale(Lnet/minecraft/core/entity/player/Player;F)V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glColor4f(FFFF)V", ordinal=1)})
    private void renderPlayerFour(float red, float blue, float green, float alpha, Operation<Void> original, Player entity, float partialTick) {
        if (entity.getGamemode() == Gamemode.spectator) {
            original.call(new Object[]{Float.valueOf(red), Float.valueOf(blue), Float.valueOf(green), Float.valueOf(alpha)});
            return;
        }
        original.call(new Object[]{Float.valueOf(red), Float.valueOf(blue), Float.valueOf(green), Float.valueOf(0.0f)});
        GL11.glEnable((int)3042);
    }

    @Inject(method={"render(Lnet/minecraft/client/render/tessellator/Tessellator;Lnet/minecraft/core/entity/player/Player;DDDFF)V"}, at={@At(value="HEAD")})
    private void renderPlayerFive(Tessellator tessellator, Player entity, double x, double y, double z, float yaw, float partialTick, CallbackInfo ci, @Share(value="alphaTest") LocalFloatRef alphaTest) {
        alphaTest.set(GL11.glGetFloat((int)3010));
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    @Inject(method={"render(Lnet/minecraft/client/render/tessellator/Tessellator;Lnet/minecraft/core/entity/player/Player;DDDFF)V"}, at={@At(value="RETURN")})
    private void renderPlayerSix(Tessellator tessellator, Player entity, double x, double y, double z, float yaw, float partialTick, CallbackInfo ci, @Share(value="alphaTest") LocalFloatRef alphaTest) {
        GL11.glAlphaFunc((int)516, (float)alphaTest.get());
    }

    @ModifyArg(method={"prepareArmor*"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/player/inventory/container/ContainerInventory;armorItemInSlot(I)Lnet/minecraft/core/item/ItemStack;"))
    private int getArmorItemNotNegative(int i, @Local(argsOnly=true) int renderPass) {
        return renderPass > 3 ? renderPass : 3 - renderPass;
    }

    @ModifyReturnValue(method={"prepareArmor(Lnet/minecraft/core/entity/player/Player;IF)Z"}, at={@At(value="TAIL")})
    private boolean setArmorModel(boolean original, Player entity, int layer, float partialTick) {
        float swingProgress;
        this.modelBubble.holdingLarge = this.modelHeart.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelFeather.holdingLarge = this.modelHeart.holdingLarge;
        this.shield.holdingLarge = this.modelHeart.holdingLarge;
        this.modelAccessories.holdingLarge = this.modelHeart.holdingLarge;
        this.modelBubble.holdingRightHand = this.modelHeart.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelFeather.holdingRightHand = this.modelHeart.holdingRightHand;
        this.shield.holdingRightHand = this.modelHeart.holdingRightHand;
        this.modelAccessories.holdingRightHand = this.modelHeart.holdingRightHand;
        this.modelBubble.holdingLeftHand = this.modelHeart.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
        this.modelFeather.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.shield.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.modelAccessories.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.modelBubble.sneaking = this.modelHeart.sneaking = this.modelBipedMain.sneaking;
        this.modelFeather.sneaking = this.modelHeart.sneaking;
        this.shield.sneaking = this.modelHeart.sneaking;
        this.modelAccessories.sneaking = this.modelHeart.sneaking;
        this.modelBubble.isRiding = this.modelHeart.isRiding = this.modelBipedMain.isRiding;
        this.modelFeather.isRiding = this.modelHeart.isRiding;
        this.shield.isRiding = this.modelHeart.isRiding;
        this.modelAccessories.isRiding = this.modelHeart.isRiding;
        this.modelArmor.onGround = this.modelArmorChestplate.onGround = (swingProgress = this.getSwingProgress((Mob)entity, partialTick));
        this.modelHeart.onGround = this.modelArmorChestplate.onGround;
        this.modelBubble.onGround = this.modelArmorChestplate.onGround;
        this.modelFeather.onGround = this.modelArmorChestplate.onGround;
        this.shield.onGround = this.modelArmorChestplate.onGround;
        this.modelAccessories.onGround = this.modelArmorChestplate.onGround;
        ItemStack armorStack = entity.inventory.armorInventory[layer];
        if (armorStack != null && armorStack.getItem() instanceof IAccessory && layer >= 4) {
            Item item = armorStack.getItem();
            if (item instanceof ItemGloves) {
                String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
                this.modelArmorChestplate.holdingRightHand = entity.inventory.getCurrentItem() != null;
                this.modelArmorChestplate.sneaking = entity.isSneaking();
                this.modelArmorChestplate.isRiding = entity.isPassenger();
                this.modelArmorChestplate.armLeft.visible = layer == 4;
                this.modelArmorChestplate.armRight.visible = layer == 4;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelArmorChestplate);
                return true;
            }
            if (item instanceof ItemRepulsionShield && (layer == 7 || entity.inventory.armorInventory[7] == null) || this.shield6) {
                this.shield6 = false;
                String path = ((AetherRepulsion)entity).aether$isRepulse() ? String.format("/assets/%s/textures/armor/energyGlow.png", item.namespaceID.namespace()) : String.format("/assets/%s/textures/armor/energyNotGlow.png", item.namespaceID.namespace());
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                GLManager.glEnable(2884);
                GLManager.glEnable(3042);
                if (((AetherInvisibility)entity).aether$isInvisible()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    GL11.glEnable((int)3042);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glBlendFunc((int)770, (int)771);
                }
                this.setArmorModel((ModelBase)this.shield);
                return true;
            }
            if (item instanceof ItemRepulsionShield && layer == 6) {
                this.shield6 = true;
                ItemStack nextSlot = entity.inventory.armorInventory[layer + 1];
                item = nextSlot.getItem();
                ++layer;
            }
            ItemStack itemTrinketSlot1 = entity.inventory.armorInventory[6];
            ItemStack itemTrinketSlot2 = entity.inventory.armorInventory[7];
            if (item instanceof ItemGoldenFeather) {
                String path;
                if (layer == 6) {
                    path = "/assets/aether/textures/armor/trinkets/feather_gold_trinket_helmet.png";
                    this.setUPFeatherOnHelmet();
                } else {
                    path = "/assets/aether/textures/armor/trinkets/feather_gold_trinket_boots.png";
                    this.setUpFeathersOnBoots();
                }
                this.modelFeather.body.visible = false;
                this.modelFeather.armLeft.visible = false;
                this.modelFeather.armRight.visible = false;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelFeather);
                return true;
            }
            if (item instanceof ItemPendant) {
                int variant = 0;
                if (layer == 7 && itemTrinketSlot1 != null && itemTrinketSlot1.getItem() instanceof ItemPendant) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/pendants/%s_pendant_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.modelAccessories.body.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelAccessories);
                return true;
            }
            if (item instanceof ItemRegenStone) {
                String path = layer == 6 ? "/assets/aether/textures/armor/trinkets/regen_trinket_right.png" : "/assets/aether/textures/armor/trinkets/regen_trinket_left.png";
                this.modelHeart.head.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelHeart);
                return true;
            }
            if (item instanceof ItemIronBubble) {
                boolean isInTrinketSlot2;
                boolean isInTrinketSlot1 = itemTrinketSlot1 != null && itemTrinketSlot1.getItem() instanceof ItemIronBubble;
                boolean bl = isInTrinketSlot2 = itemTrinketSlot2 != null && itemTrinketSlot2.getItem() instanceof ItemIronBubble;
                if (isInTrinketSlot1 && layer == 6 || isInTrinketSlot2 && !isInTrinketSlot1 && layer == 7) {
                    String path = "/assets/aether/textures/armor/trinkets/bubble_trinket.png";
                    this.modelBubble.head.visible = true;
                    this.modelBubble.body.visible = false;
                    this.modelBubble.armLeft.visible = false;
                    this.modelBubble.armRight.visible = false;
                    this.modelBubble.legLeft.visible = false;
                    this.modelBubble.legRight.visible = false;
                    this.renderDispatcher.textureManager.loadTexture(path).bind();
                    GLManager.glEnable(2884);
                    GLManager.glEnable(3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.setArmorModel((ModelBase)this.modelBubble);
                    return true;
                }
            }
        }
        return false;
    }

    @Unique
    private void setUPFeatherOnHelmet() {
        this.modelFeather.head.visible = true;
        this.modelFeather.legLeft.visible = false;
        this.modelFeather.legRight.visible = false;
        this.modelFeather.head.addBox(-4.0f, -12.0f, -4.0f, 8, 12, 12, 1.1f);
    }

    @Unique
    private void setUpFeathersOnBoots() {
        this.modelFeather.head.visible = false;
        this.modelFeather.legLeft.visible = true;
        this.modelFeather.legRight.visible = true;
        this.modelFeather.legLeft.addBox(-2.0f, 2.0f, -3.0f, 4, 12, 8, 1.1f);
        this.modelFeather.legRight.addBox(-2.0f, 2.0f, -3.0f, 4, 12, 8, 1.1f);
    }
}

