/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory.trinket;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.item.AetherItems;

@Mixin(value={ContainerInventory.class}, remap=false)
public abstract class ContainerInventoryZanitePendantDamageMixin {
    @Shadow
    public ItemStack[] mainInventory;
    @Shadow
    public Player player;

    @ModifyReturnValue(method={"getDamageVsEntity"}, at={@At(value="RETURN")})
    private int getGloveDamage(int damage) {
        ItemStack trinketOne = this.player.inventory.armorInventory[6];
        ItemStack trinketTwo = this.player.inventory.armorInventory[7];
        if (trinketOne != null && trinketOne.itemID == AetherItems.ARMOR_TALISMAN_ZANITE.id) {
            damage = this.addDamage(damage, trinketOne);
        }
        if (trinketTwo != null && trinketTwo.itemID == AetherItems.ARMOR_TALISMAN_ZANITE.id) {
            damage = this.addDamage(damage, trinketTwo);
        }
        return damage;
    }

    @Unique
    private int addDamage(int damage, ItemStack trinketOne) {
        float damagePercent = (float)trinketOne.getMetadata() / (float)trinketOne.getMaxDamage();
        float speed = MathHelper.lerp((float)0.0f, (float)3.0f, (float)damagePercent);
        trinketOne.damageItem(1, (Entity)this.player);
        return damage += (int)Math.floor(speed);
    }
}

