/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.player.phoenix;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.helper.MixinHelper;
import teamport.aether.helper.ParticleMaker;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerMixinFireImmunity
extends Mob {
    @Shadow
    public ContainerInventory inventory;

    protected PlayerMixinFireImmunity(@Nullable World world) {
        super(world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (this.isInLava() || this.isInWater()) {
            return;
        }
        if (MixinHelper.fireResistanceCount(this.inventory) >= 3 && this.random.nextInt(6) == 0) {
            ParticleMaker.spawnFlameParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
        }
        if (MixinHelper.fireResistanceCount(this.inventory) >= 5 && this.random.nextInt(3) == 0) {
            ParticleMaker.spawnFlameParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
        }
    }

    @ModifyExpressionValue(method={"lavaHurt"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="fireImmune", field={"Lnet/minecraft/core/entity/player/Player;fireImmune:Z"})
    @Expression(value={"this.fireImmune"})
    private boolean aether$lavaImmunity(boolean original) {
        if (MixinHelper.fireResistanceCount(this.inventory) >= 5) {
            MixinHelper.damageArmourWithEffect(4, (Player)this, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return true;
        }
        return original;
    }

    @ModifyExpressionValue(method={"fireHurt"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="fireImmune", field={"Lnet/minecraft/core/entity/player/Player;fireImmune:Z"})
    @Expression(value={"this.fireImmune"})
    private boolean aether$fireImmunity(boolean original) {
        if (MixinHelper.fireResistanceCount(this.inventory) >= 3) {
            MixinHelper.damageArmourWithEffect(4, (Player)this, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return true;
        }
        return original;
    }
}

