/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.wolf;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.item.AetherArmorMaterial;

@Mixin(value={MobWolf.class}, remap=false)
public abstract class MobWolfMixinZaniteResistance
extends MobAnimal {
    protected MobWolfMixinZaniteResistance(World world) {
        super(world);
    }

    @Shadow
    public abstract int getMaxHealth();

    @WrapOperation(method={"damageEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/item/material/ArmorMaterial;getProtection(Lnet/minecraft/core/util/helper/DamageType;)F")})
    private float reduceWolfDamage(ArmorMaterial instance, DamageType damageType, Operation<Float> original) {
        if (instance != AetherArmorMaterial.ZANITE) {
            return ((Float)original.call(new Object[]{instance, damageType})).floatValue();
        }
        float healthPercentage = (float)this.getHealth() / (float)this.getMaxHealth();
        return MathHelper.lerp((float)(ArmorMaterial.GOLD.getProtection(damageType) * 1.5f), (float)instance.getProtection(damageType), (float)healthPercentage);
    }
}

