/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.fix;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import teamport.aether.AetherMod;
import teamport.aether.helper.MixinHelper;

@Mixin(value={World.class}, remap=false, priority=0)
public abstract class WorldGetCubesMixin {
    @Shadow
    public abstract @Nullable Block<?> getBlock(int var1, int var2, int var3);

    @WrapMethod(method={"getEntitiesWithinAABB"})
    private <T extends Entity> @NonNull List<@NonNull T> getEntitiesWithinAABB(Class<T> ofClass, AABB aabb, Operation<List<T>> original) {
        return MixinHelper.preventStupidShit((World)this, ofClass, null, aabb, original);
    }

    @WrapMethod(method={"getEntitiesWithinAABBExcludingEntity"})
    private List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AABB aabb, Operation<List<Entity>> original) {
        return MixinHelper.preventStupidShit((World)this, null, entity, aabb, original);
    }

    @WrapMethod(method={"getCubes"})
    private List<AABB> getCubes(Entity entity, AABB aabb, Operation<List<AABB>> original) {
        if (MixinHelper.isBrokenAABB(aabb)) {
            if (AetherMod.LOGGER.isErrorEnabled()) {
                AetherMod.LOGGER.error("{} is moving too fast!! Please send this to a developer!", (Object)Entity.getNameFromEntity((Entity)entity, (boolean)true));
            }
            Thread.dumpStack();
            entity.absMoveTo(0.0, 255.0, 0.0, 0.0f, 0.0f);
            entity.xo = 0.0;
            entity.yo = 0.0;
            entity.zo = 0.0;
            return new ArrayList<AABB>();
        }
        return (List)original.call(new Object[]{entity, aabb});
    }
}

