/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelCrossedSquares;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import teamport.aether.block.AetherBlocks;

@Environment(value=EnvType.CLIENT)
public class BlockModelAetherTallgrass<T extends BlockLogic>
extends BlockModelCrossedSquares<T> {
    public BlockModelAetherTallgrass(Block<T> block) {
        super(block);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(BlockModelAetherTallgrass.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelAetherTallgrass.renderBlocks.blockAccess, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)this.block)).getWorldColor(BlockModelAetherTallgrass.renderBlocks.blockAccess, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(brightness * r, brightness * g, brightness * b);
        double xd = x;
        double yd = y;
        double zd = z;
        if (this.block == AetherBlocks.TALLGRASS_AETHER) {
            long dRandom = (long)x * 3129871L ^ (long)z * 116129781L ^ (long)y;
            dRandom = dRandom * dRandom * 42317861L + dRandom * 11L;
            xd += ((double)((float)(dRandom >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            yd += ((double)((float)(dRandom >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            zd += ((double)((float)(dRandom >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        int metadata = BlockModelAetherTallgrass.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (BlockModelAetherTallgrass.renderBlocks.overrideBlockTexture != null) {
            texIndex = BlockModelAetherTallgrass.renderBlocks.overrideBlockTexture;
        }
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        double minX = xd + 0.5 - 0.45;
        double maxX = xd + 0.5 + 0.45;
        double minZ = zd + 0.5 - 0.45;
        double maxZ = zd + 0.5 + 0.45;
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        return true;
    }
}

