/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class BlockModelGrassAether<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static boolean useOverlay = false;
    private static final IconCoordinate[] overlayIndices = new IconCoordinate[]{null, null, TextureRegistry.getTexture((String)"aether:block/grass_aether/side_overlay"), TextureRegistry.getTexture((String)"aether:block/grass_aether/side_overlay"), TextureRegistry.getTexture((String)"aether:block/grass_aether/side_overlay"), TextureRegistry.getTexture((String)"aether:block/grass_aether/side_overlay")};
    protected IconCoordinate snowSide = TextureRegistry.getTexture((String)"aether:block/grass_aether/snowy_side");
    protected IconCoordinate retroSnowSide = TextureRegistry.getTexture((String)"aether:block/grass_aether/snowy_side_retro");

    public BlockModelGrassAether(Block<T> block) {
        super(block);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        boolean didRender;
        AABB bounds = this.block.getBounds();
        boolean bl = didRender = this.isRetro() ? this.renderStandardBlock(tessellator, bounds, x, y, z, 1.0f, 1.0f, 1.0f) : this.renderStandardBlock(tessellator, bounds, x, y, z);
        if (!(!RenderBlocks.fancyGrass || this.retroBlockTextures.hasTexture() && this.isRetro())) {
            useOverlay = true;
            didRender |= this.renderStandardBlock(tessellator, bounds, x, y, z);
            useOverlay = false;
        }
        return didRender;
    }

    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        float yOffset = 0.5f;
        AABB bounds = this.getBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (BlockModelGrassAether.renderBlocks.useInventoryTint && !this.isRetro()) {
            int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)this.block)).getFallbackColor(metadata);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f8 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f9 = (float)(l & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f4 * brightness), (float)(f8 * brightness), (float)(f9 * brightness), (float)alpha);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        if (RenderBlocks.fancyGrass && !this.isRetro()) {
            useOverlay = true;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            useOverlay = false;
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        boolean isSnowy;
        Material above = blockAccess.getBlockMaterial(x, y + 1, z);
        boolean bl = isSnowy = above == Material.topSnow || above == Material.snow;
        if (isSnowy && side.getAxis() != Axis.Y) {
            return this.isRetro() ? this.retroSnowSide : this.snowSide;
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return useOverlay ? overlayIndices[side.getId()] : super.getBlockTextureFromSideAndMetadata(side, data);
    }

    public boolean shouldSideBeColored(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        Material material = blockAccess.getBlockMaterial(x, y + 1, z);
        if (material != Material.topSnow && material != Material.snow) {
            return useOverlay || side == Side.TOP.getId();
        }
        return false;
    }
}

