/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net;

import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.net.entity.EntityTracker;
import net.minecraft.core.net.entity.EntityTrackerEntry;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.entity.projectile.ProjectileArrowFlaming;
import teamport.aether.entity.projectile.ProjectileDart;
import teamport.aether.entity.projectile.ProjectileElementFire;
import teamport.aether.entity.projectile.ProjectileElementIce;
import teamport.aether.entity.projectile.ProjectileElementLightning;
import teamport.aether.entity.projectile.ProjectileHammerHead;
import teamport.aether.entity.projectile.ProjectileKnifeLightning;
import teamport.aether.entity.projectile.ProjectileNeedle;
import teamport.aether.entity.projectile.ProjectileWindball;

public class NetEntryAetherProjectile
implements IVehicleEntry<ProjectileAether>,
ITrackedEntry<ProjectileAether> {
    private static final int TYPE_BITS = -16777216;
    private static final Map<Integer, ProjectileAether.ConstructorLambda> ID_TO_CONSTRUCTOR = new HashMap<Integer, ProjectileAether.ConstructorLambda>();
    private static final Map<Class<?>, Integer> CLASS_TO_ID = new HashMap();

    public static void register(int id, ProjectileAether.ConstructorLambda constructor, Class<?> clazz) {
        ID_TO_CONSTRUCTOR.put(id, constructor);
        CLASS_TO_ID.put(clazz, id);
    }

    public static int getIdBits(ProjectileAether projectile) {
        return CLASS_TO_ID.get(projectile.getClass()) << 24;
    }

    public PacketAddEntity getSpawnPacket(EntityTrackerEntry entityTrackerEntry, ProjectileAether tracked) {
        PacketAddEntity packet = tracked.getSpawnPacket((Projectile)tracked);
        packet.metaData |= NetEntryAetherProjectile.getIdBits(tracked);
        return packet;
    }

    public int getTrackingDistance() {
        return 64;
    }

    public int getPacketDelay() {
        return 20;
    }

    public boolean sendMotionUpdates() {
        return false;
    }

    public void onEntityTracked(EntityTracker entityTracker, EntityTrackerEntry entityTrackerEntry, ProjectileAether tracked) {
    }

    public @NonNull Class<? extends ProjectileAether> getAppliedClass() {
        return ProjectileAether.class;
    }

    public Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        ProjectileAether.ConstructorLambda projectile = ID_TO_CONSTRUCTOR.get(meta >>> 24);
        return projectile.getEntity(world, x, y, z, meta & 0xFFFFFF, hasVelocity, xd, yd, zd, owner);
    }

    static {
        NetEntryAetherProjectile.register(0, ProjectileArrowFlaming::getEntity, ProjectileArrowFlaming.class);
        NetEntryAetherProjectile.register(1, ProjectileDart::getEntity, ProjectileDart.class);
        NetEntryAetherProjectile.register(2, ProjectileKnifeLightning::getEntity, ProjectileKnifeLightning.class);
        NetEntryAetherProjectile.register(3, ProjectileHammerHead::getEntity, ProjectileHammerHead.class);
        NetEntryAetherProjectile.register(4, ProjectileWindball::getEntity, ProjectileWindball.class);
        NetEntryAetherProjectile.register(5, ProjectileNeedle::getEntity, ProjectileNeedle.class);
        NetEntryAetherProjectile.register(6, ProjectileElementLightning::getEntity, ProjectileElementLightning.class);
        NetEntryAetherProjectile.register(7, ProjectileElementFire::getEntity, ProjectileElementFire.class);
        NetEntryAetherProjectile.register(8, ProjectileElementIce::getEntity, ProjectileElementIce.class);
    }
}

