/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import java.util.UUID;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import teamport.aether.item.accessory.AetherInvisibility;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class AetherSyncInvisibilityNetworkMessage
implements NetworkMessage {
    private UUID playerUUID;
    private boolean invisibility;

    public AetherSyncInvisibilityNetworkMessage() {
    }

    public AetherSyncInvisibilityNetworkMessage(Player player) {
        this.playerUUID = player.uuid;
        this.invisibility = ((AetherInvisibility)player).aether$isInvisible();
    }

    public void encodeToUniversalPacket(@NonNull UniversalPacket packet) {
        packet.writeUUID(this.playerUUID);
        packet.writeBoolean(this.invisibility);
    }

    public void decodeFromUniversalPacket(@NonNull UniversalPacket packet) {
        this.playerUUID = packet.readUUID();
        this.invisibility = packet.readBoolean();
    }

    public void handleClientEnv(NetworkMessage.NetworkContext context) {
        World world = context.player.world;
        if (world != null) {
            world.players.stream().filter(p -> p.uuid.equals(this.playerUUID)).forEach(p -> ((AetherInvisibility)p).aether$SyncVisibility(this.invisibility));
        }
    }
}

