/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import java.util.UUID;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import teamport.aether.item.AetherRepulsion;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class AetherSyncRepulsionNetworkMessage
implements NetworkMessage {
    private UUID playerUUID;
    private boolean repulsion;

    public AetherSyncRepulsionNetworkMessage() {
    }

    public AetherSyncRepulsionNetworkMessage(Player player) {
        this.playerUUID = player.uuid;
        this.repulsion = ((AetherRepulsion)player).aether$isRepulse();
    }

    public void encodeToUniversalPacket(@NonNull UniversalPacket packet) {
        packet.writeUUID(this.playerUUID);
        packet.writeBoolean(this.repulsion);
    }

    public void decodeFromUniversalPacket(@NonNull UniversalPacket packet) {
        this.playerUUID = packet.readUUID();
        this.repulsion = packet.readBoolean();
    }

    public void handleClientEnv(NetworkMessage.NetworkContext context) {
        World world = context.player.world;
        if (world != null) {
            world.players.stream().filter(p -> p.uuid.equals(this.playerUUID)).forEach(p -> ((AetherRepulsion)p).aether$SyncRepulsion(this.repulsion));
        }
    }
}

