/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.block.AetherBlocks;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class JumpRoom
extends BaseBronzeRoom {
    private static final BlockPallet JUMP_MIMICS = new BlockPallet();

    public JumpRoom() {
        this.height = 15;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    @Override
    public void makeRoom() {
        this.room.add(WorldFeatureComponent.drawShell(this.random, ROOM_PALLET, Direction.EAST, 12, Direction.UP, this.height, Direction.SOUTH, 12, this.x, this.y, this.z, false));
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 10, Direction.UP, this.height - 2, Direction.SOUTH, 10, this.x + 1, this.y + 1, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, Direction.SOUTH, 2, Direction.EAST, 4, this.x + 4, this.y + 7, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, Direction.SOUTH, 4, Direction.EAST, 2, this.x + 1, this.y + 7, this.z + 4, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, Direction.SOUTH, 4, Direction.EAST, 2, this.x + 9, this.y + 7, this.z + 4, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, Direction.SOUTH, 2, Direction.EAST, 4, this.x + 4, this.y + 7, this.z + 9, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.AERCLOUD_BLUE.id(), 0, Direction.SOUTH, 3, Direction.EAST, 3, this.x + 1, this.y, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.AERCLOUD_BLUE.id(), 0, Direction.SOUTH, 3, Direction.WEST, 3, this.x + 10, this.y, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.AERCLOUD_BLUE.id(), 0, Direction.NORTH, 3, Direction.EAST, 3, this.x + 1, this.y, this.z + 10, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.AERCLOUD_BLUE.id(), 0, Direction.NORTH, 3, Direction.WEST, 3, this.x + 10, this.y, this.z + 10, false));
        ArrayList<WorldFeatureComponent> listChestPos = new ArrayList<WorldFeatureComponent>();
        listChestPos.add(WorldFeatureComponent.drawLine(this.random, JUMP_MIMICS, Direction.EAST, 2, this.x + 5, this.y + 8, this.z + 1, false));
        listChestPos.add(WorldFeatureComponent.drawLine(this.random, JUMP_MIMICS, Direction.SOUTH, 2, this.x + 1, this.y + 8, this.z + 5, false));
        listChestPos.add(WorldFeatureComponent.drawLine(this.random, JUMP_MIMICS, Direction.SOUTH, 2, this.x + 10, this.y + 8, this.z + 5, false));
        listChestPos.add(WorldFeatureComponent.drawLine(this.random, JUMP_MIMICS, Direction.EAST, 2, this.x + 5, this.y + 8, this.z + 10, false));
        Collections.shuffle(listChestPos, this.random);
        int max = this.random.nextInt(2) + 2;
        for (int i = 0; i < max; ++i) {
            this.chest.add((WorldFeatureComponent)listChestPos.get(i));
        }
    }

    static {
        JUMP_MIMICS.addEntry(0, 1.25);
        JUMP_MIMICS.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 2.0);
        JUMP_MIMICS.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 2.0);
    }
}

