/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.block.AetherBlocks;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class StairwellRoom
extends BaseBronzeRoom {
    public StairwellRoom() {
        this.roomWeight = 0.25f;
        this.height = 30;
        this.width = 8;
        this.length = 8;
        this.bottomLiquidTolerance = 1.0f;
        this.topLiquidTolerance = 1.0f;
        this.bottomAirTolerance = 1.0f;
        this.topAirTolerance = 1.0f;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(2, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(7, 1, 2), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(2, 1, 7), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 2), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(2, this.height - 8, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(7, this.height - 8, 2), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(2, this.height - 8, 7), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, this.height - 8, 2), Direction.UP, 6, Direction.SOUTH, 4);
    }

    @Override
    public void makeRoom() {
        WorldFeaturePoint offset;
        this.room.add(WorldFeatureComponent.drawHollowShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, 9, Direction.EAST, this.width, this.x, this.y, this.z, false));
        this.room.add(WorldFeatureComponent.drawHollowShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, 9, Direction.EAST, this.width, this.x, this.y + this.height - 9, this.z, false));
        this.decoration.add(WorldFeatureComponent.drawSquareCylinder(this.random, ROOM_PALLET, Direction.SOUTH, this.width - 2, Direction.EAST, this.width - 2, Direction.UP, this.height - 16, this.x + 1, this.y + 8, this.z + 1, false));
        Direction dir = Direction.horizontalDirections[this.random.nextInt(4)];
        WorldFeatureComponent staircase = new WorldFeatureComponent();
        switch (dir) {
            case WEST: {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 4, Direction.UP, 1, Direction.EAST, 1, this.x + 5, this.y + this.height - 9, this.z + 2, false));
                offset = WorldFeaturePoint.wfp(0, 0, 0);
                break;
            }
            case SOUTH: {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 1, Direction.UP, 1, Direction.EAST, 4, this.x + 2, this.y + this.height - 9, this.z + 2, false));
                offset = WorldFeaturePoint.wfp(3, 0, 0);
                break;
            }
            case EAST: {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 4, Direction.UP, 1, Direction.EAST, 1, this.x + 2, this.y + this.height - 9, this.z + 2, false));
                offset = WorldFeaturePoint.wfp(3, 0, -3);
                break;
            }
            case NORTH: {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 1, Direction.UP, 1, Direction.EAST, 4, this.x + 2, this.y + this.height - 9, this.z + 5, false));
                offset = WorldFeaturePoint.wfp(0, 0, -3);
                break;
            }
            default: {
                offset = WorldFeaturePoint.wfp(0, 0, 0);
            }
        }
        WorldFeaturePoint stepPosition = WorldFeaturePoint.wfp(this.x + 2, this.y + 1, this.z + 5);
        for (int i = 0; i < this.height - 9 << 1; ++i) {
            if (i % 3 == 0) {
                dir = dir.rotate(1);
            }
            stepPosition.moveInDirection(dir);
            staircase.add(WorldFeatureBlock.wfb(stepPosition.getX(), stepPosition.getY() + MathHelper.floor((double)((float)i / 2.0f)), stepPosition.getZ(), AetherBlocks.SLAB_CARVED_STONE.id(), i & 1));
        }
        staircase.moveByOffset(offset);
        this.decoration.add(staircase);
        this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.UP, this.height, Direction.EAST, 2, this.x + 3, this.y, this.z + 3, false));
    }
}

