/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.gold;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureFlowers;
import net.minecraft.core.world.generate.feature.WorldFeatureTallGrass;
import teamport.aether.block.AetherBlocks;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.helper.AetherMathHelper;
import teamport.aether.helper.Pair;
import teamport.aether.helper.unboxed.IntPair;
import teamport.aether.item.AetherItems;
import teamport.aether.world.feature.chest.WorldFeatureAetherGoldChest;
import teamport.aether.world.feature.dungeon.gold.DungeonLogicGoldDungeon;
import teamport.aether.world.feature.terrain.WorldFeatureAetherTreeGoldenOak;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.WorldFeatureMap;

public class WorldFeatureAetherGoldDungeon
extends WorldFeatureMap<DungeonLogicGoldDungeon> {
    private static final List<Integer> STONES = Arrays.asList(AetherBlocks.COBBLE_HOLYSTONE_MOSSY.id(), AetherBlocks.COBBLE_HOLYSTONE.id());
    private static final BlockPallet HELLFIRE = new BlockPallet();
    private static final BlockPallet HOLYSTONE = new BlockPallet();
    private static final int RADIUS = 16;
    private final Direction direction;
    private WorldFeaturePoint dungeonAnchor;
    private WorldFeaturePoint bossPosition;
    private DungeonLogicGoldDungeon logic;
    private World world;
    private Random random;
    private List<WorldFeaturePoint> heightMap;
    private static final WeightedRandomBag<Supplier<? extends WorldFeature>> WORLD_FEATURE;
    private static final WeightedRandomBag<WeightedRandomLootObject> JUNK;
    private static final WeightedRandomBag<WeightedRandomLootObject> AMMO;
    private static final WeightedRandomBag<WeightedRandomLootObject> ARMOR;
    public static final WeightedRandomBag<WeightedRandomLootObject> TREASURE;

    public WorldFeatureAetherGoldDungeon(int dir) {
        this.direction = Direction.horizontalDirections[dir & 3];
    }

    public WorldFeatureAetherGoldDungeon(Random random) {
        this(random.nextInt(4));
    }

    public void placeComponent(WorldFeatureComponent component) {
        for (WorldFeatureBlock block : component.getBlockList()) {
            block.rotateYAroundPivot(this.dungeonAnchor, this.direction);
            block.place(this.world);
        }
    }

    @Override
    protected Class<DungeonLogicGoldDungeon> getAppliedClass() {
        return DungeonLogicGoldDungeon.class;
    }

    @Override
    public DungeonLogicGoldDungeon register(World world, long seed, int x, int y, int z) {
        DungeonLogicGoldDungeon theLogic = (DungeonLogicGoldDungeon)super.register(world, seed, x, y, z);
        theLogic.direction = this.direction;
        return theLogic;
    }

    @Override
    public boolean canPlace(World world, int x, int y, int z) {
        int[][] directions;
        int checkDistance = 30;
        for (int[] dir : directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            for (int i = 1; i <= 30; ++i) {
                int checkX = x + i * dir[0];
                int checkY = y + i * dir[1];
                int checkZ = z + i * dir[2];
                Material blockMaterial = world.getBlockMaterial(checkX, checkY, checkZ);
                if (blockMaterial == Material.air) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean generate(DungeonLogicGoldDungeon logic, World world, long seed, int x, int y, int z) {
        this.world = world;
        this.random = new Random(logic.seed);
        this.logic = logic;
        this.dungeonAnchor = new WorldFeaturePoint(x, y, z);
        this.bossPosition = new WorldFeaturePoint(x, y + 8 + 2, z);
        this.heightMap = new ArrayList<WorldFeaturePoint>();
        this.createMainSphere(x, y, z);
        this.createOuterSpheres(x, y, z);
        this.createMainRoom(x, y, z);
        this.createBossAndTreasure(x, y, z);
        this.createHeightMap(x, y, z);
        this.createGrassOnTopLevel();
        this.createDecorations();
        return true;
    }

    public static List<ItemStack> generateLoot(Random random) {
        int i;
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        int count = random.nextInt(3) + 8;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)JUNK.getRandom(random)).getItemStack());
        }
        count = random.nextInt(7) + 4;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)AMMO.getRandom(random)).getItemStack());
        }
        count = AetherMathHelper.invertedExponentialCapped(random, 0.5f, 2) + 1;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)ARMOR.getRandom(random)).getItemStack());
        }
        return loot;
    }

    private void createMainSphere(int x, int y, int z) {
        WorldFeatureComponent.drawSpheroid(this.random, HOLYSTONE, x, y + 15, z, 16, 17, 16, false).place(this.world);
        WorldFeatureBlock.wfb(x, (int)Math.floor(33.6 + (double)y) - 1, z, 0, 0, false).place(this.world);
        WorldFeatureBlock.wfb(x, (int)Math.floor(33.6 + (double)y) - 2, z, AetherBlocks.GRASS_AETHER.id(), 0, false).place(this.world);
    }

    private void createOuterSpheres(int x, int y, int z) {
        ArrayList<Integer> angles = new ArrayList<Integer>();
        for (int angle = 0; angle < 10; ++angle) {
            angles.add(angle * 36);
        }
        int sphereCount = 6 + this.random.nextInt(4);
        for (int index = 0; index < sphereCount; ++index) {
            int angleIndex = this.random.nextInt(angles.size());
            int angle = (Integer)angles.remove(angleIndex);
            double newX = (double)x + 16.0 * Math.cos(Math.toRadians(angle));
            double newZ = (double)z + 16.0 * Math.sin(Math.toRadians(angle));
            double radMod = (double)(4 + this.random.nextInt(5)) / 10.0;
            WorldFeatureComponent.drawSphere(this.random, HOLYSTONE, (int)newX, (int)((float)y + 12.8f), (int)newZ, (int)(16.0 * radMod), false).place(this.world);
        }
        double radMod2 = 0.5;
        WorldFeaturePoint cover = new WorldFeaturePoint(x, (int)((float)y + 12.8f), z + 16);
        cover.rotateYAroundPivot(this.dungeonAnchor, this.direction);
        WorldFeatureComponent.drawSphere(this.random, HOLYSTONE, cover.getX(), cover.getY(), cover.getZ(), (int)(16.0 * radMod2), false).place(this.world);
    }

    private void createMainRoom(int x, int y, int z) {
        int xRoomLength = 19;
        int yRoomHeight = 8;
        int zRoomLength = 19;
        WorldFeatureComponent main = new WorldFeatureComponent();
        Pair<WorldFeaturePoint, WorldFeaturePoint> clearArea = new Pair<WorldFeaturePoint, WorldFeaturePoint>(new WorldFeaturePoint(x + 1 + 8 + 8, y + 8, z + 1 + 8), new WorldFeaturePoint(x + 1 + 8 - xRoomLength, y + 8 + yRoomHeight, z + 1 + 8 - zRoomLength));
        clearArea.getFirst().rotateYAroundPivot(this.dungeonAnchor, this.direction);
        clearArea.getSecond().rotateYAroundPivot(this.dungeonAnchor, this.direction);
        this.logic.setClearArea(clearArea);
        main.add(WorldFeatureComponent.drawHollowShell(this.random, HELLFIRE, Direction.WEST, xRoomLength, Direction.NORTH, zRoomLength, Direction.UP, yRoomHeight, x + 1 + 8, y + 8, z + 1 + 8, false));
        main.add(WorldFeatureComponent.drawSquareCylinder(this.random, HELLFIRE, Direction.WEST, xRoomLength - 2, Direction.NORTH, zRoomLength - 2, Direction.UP, 1, x + 8, y + 1 + 8, z + 8, false));
        main.add(WorldFeatureComponent.drawSquareCylinder(this.random, HELLFIRE, Direction.WEST, xRoomLength - 2, Direction.NORTH, zRoomLength - 2, Direction.UP, 1, x + 8, y + yRoomHeight - 2 + 8, z + 8, false));
        main.add(WorldFeatureComponent.drawVolume(0, 0, Direction.NORTH, 32, Direction.WEST, 3, Direction.UP, 3, x + 1, y + 2 + 8, z - 8 - 1, false));
        this.world.setBlock(x, y, z, AetherBlocks.BLOCK_GRAVITITE.id());
        WorldFeatureComponent entranceDoor = new WorldFeatureComponent();
        int entranceDoorMeta = BlockLogicRotatable.setDirection((int)0, (Direction)this.direction);
        WorldFeatureComponent.iterate3d(WorldFeaturePoint.wfp(x + 2, y + 2 + 8, z - 8), WorldFeaturePoint.wfp(x - 1, y + 5 + 8, z - 1 - 8), w -> entranceDoor.add(WorldFeatureBlock.wfb(w, AetherBlocks.DOOR_DUNGEON_GOLD.id(), entranceDoorMeta, true)));
        entranceDoor.rotateYAroundPivot(this.dungeonAnchor, this.direction);
        this.logic.setEntranceDoor(entranceDoor.getBlockList());
        this.placeComponent(main);
    }

    private void createBossAndTreasure(int x, int y, int z) {
        WorldFeatureComponent treasureRoom = WorldFeatureComponent.drawHollowShell(this.random, HELLFIRE, Direction.SOUTH, 7, Direction.WEST, 7, Direction.UP, 5, x + 3, y + 1 + 8, z + 8 + 1, false);
        this.placeComponent(treasureRoom);
        MobBossSunspirit boss = new MobBossSunspirit(this.world);
        boss.moveTo(this.bossPosition.getX(), this.bossPosition.getY(), this.bossPosition.getZ(), 0.0f, 0.0f);
        boss.setReturnPoint(new WorldFeaturePoint(this.bossPosition.getX(), this.bossPosition.getY(), this.bossPosition.getZ()));
        boss.setDungeonID(this.logic.id);
        boss.setTrophy(AetherItems.KEY_GOLD.getDefaultStack());
        this.world.entityJoinedWorld((Entity)boss);
        WorldFeaturePoint chestPoint = new WorldFeaturePoint(x, y + 2 + 8, z - 4 + 16);
        chestPoint.rotateYAroundPivot(this.dungeonAnchor, this.direction);
        new WorldFeatureAetherGoldChest(this.direction).place(this.world, this.random, chestPoint.getX(), chestPoint.getY(), chestPoint.getZ());
        WorldFeaturePoint anchor = WorldFeaturePoint.wfp(x, y, z);
        ArrayList<WorldFeaturePoint> treasureDoor = new ArrayList<WorldFeaturePoint>();
        treasureDoor.add(new WorldFeaturePoint(x - 1, y + 2 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x - 1, y + 3 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x - 1, y + 4 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x, y + 2 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x, y + 3 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x, y + 4 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x + 1, y + 2 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x + 1, y + 3 + 8, z + 16 - 7));
        treasureDoor.add(new WorldFeaturePoint(x + 1, y + 4 + 8, z + 16 - 7));
        treasureDoor.forEach(p -> p.rotateYAroundPivot(anchor, this.direction));
        this.logic.setTreasureDoor(treasureDoor);
        Pair<WorldFeaturePoint, WorldFeaturePoint> clearArea = new Pair<WorldFeaturePoint, WorldFeaturePoint>(new WorldFeaturePoint(x - 16 - 8, y - 5, z - 16 - 8), new WorldFeaturePoint(x + 16 + 8, y + 16 + 8, z + 16 + 8));
        clearArea.getFirst().rotateYAroundPivot(this.dungeonAnchor, this.direction);
        clearArea.getSecond().rotateYAroundPivot(this.dungeonAnchor, this.direction);
        this.logic.setClearArea(clearArea);
    }

    public void createHeightMap(int x, int y, int z) {
        int diameter = 32;
        Set hell = HELLFIRE.getPallet().getEntries().stream().map(IntPair::getFirst).collect(Collectors.toSet());
        for (int ix = -diameter; ix < diameter; ++ix) {
            block1: for (int iz = -diameter; iz < diameter; ++iz) {
                if (diameter * diameter < ix * ix + iz * iz) continue;
                for (int iy = y + diameter; iy > y + 16 - 4; --iy) {
                    int id = this.world.getBlockId(x + ix, iy - 1, z + iz);
                    if (id == 0 || !STONES.contains(id) || hell.contains(id)) continue;
                    this.heightMap.add(new WorldFeaturePoint(ix + x, iy, iz + z));
                    continue block1;
                }
            }
        }
    }

    private void createGrassOnTopLevel() {
        for (WorldFeaturePoint p : this.heightMap) {
            int x = p.getX();
            int y = p.getY();
            int z = p.getZ();
            WorldFeatureComponent dirt = new WorldFeatureComponent();
            if (STONES.contains(this.world.getBlockId(x, y - 1, z))) {
                dirt.add(WorldFeatureBlock.wfb(x, y - 1, z, AetherBlocks.GRASS_AETHER.id()));
            }
            if (STONES.contains(this.world.getBlockId(x, y - 2, z))) {
                dirt.add(WorldFeatureBlock.wfb(x, y - 2, z, AetherBlocks.DIRT_AETHER.id()));
            }
            if (STONES.contains(this.world.getBlockId(x, y - 3, z))) {
                dirt.add(WorldFeatureBlock.wfb(x, y - 3, z, AetherBlocks.DIRT_AETHER.id()));
            }
            if (STONES.contains(this.world.getBlockId(x, y - 4, z)) && this.world.rand.nextInt(10) > 3) {
                dirt.add(WorldFeatureBlock.wfb(x, y - 4, z, AetherBlocks.DIRT_AETHER.id()));
            }
            dirt.place(this.world);
        }
    }

    private void createDecorations() {
        for (WorldFeaturePoint point : this.heightMap) {
            Supplier feature = (Supplier)WORLD_FEATURE.getRandom(this.random);
            if (feature == null) continue;
            ((WorldFeature)feature.get()).place(this.world, this.random, point.getX(), point.getY(), point.getZ());
        }
    }

    static {
        HELLFIRE.addEntry(AetherBlocks.CARVED_HELLFIRE_LOCKED.id(), 0, 90.0);
        HELLFIRE.addEntry(AetherBlocks.CARVED_HELLFIRE_LIGHT_LOCKED.id(), 0, 10.0);
        HOLYSTONE.addEntry(AetherBlocks.COBBLE_HOLYSTONE.id(), 0, 90.0);
        HOLYSTONE.addEntry(AetherBlocks.COBBLE_HOLYSTONE_MOSSY.id(), 0, 10.0);
        WORLD_FEATURE = new WeightedRandomBag();
        WORLD_FEATURE.addEntry(null, 512.0);
        WORLD_FEATURE.addEntry(() -> new WorldFeatureTallGrass(AetherBlocks.TALLGRASS_AETHER.id()), 16.0);
        WORLD_FEATURE.addEntry(() -> new WorldFeatureFlowers(AetherBlocks.FLOWER_WHITE.id(), 64, true), 4.0);
        WORLD_FEATURE.addEntry(() -> new WorldFeatureFlowers(AetherBlocks.FLOWER_PURPLE.id(), 64, true), 4.0);
        WORLD_FEATURE.addEntry(WorldFeatureAetherTreeGoldenOak::new, 8.0);
        JUNK = new WeightedRandomBag();
        AMMO = new WeightedRandomBag();
        ARMOR = new WeightedRandomBag();
        JUNK.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.BLOCK_AMBER.getDefaultStack(), 1, 8), 4.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.BLOCK_AMBROSIUM.getDefaultStack(), 1, 6), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.BLOCK_ZANITE.getDefaultStack(), 1, 4), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.BLOCK_GRAVITITE.getDefaultStack(), 1, 2), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.EGG_MOA_BLACK.getDefaultStack()), 1.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_GOLDEN.getDefaultStack(), 2, 6), 4.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_POISON.getDefaultStack(), 2, 6), 2.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_ENCHANTED.getDefaultStack(), 2, 6), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_AXE_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_PICKAXE_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SHOVEL_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_ZANITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_GLOVES_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_BOOTS_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_HELMET_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_CHESTPLATE_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_LEGGINGS_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_GRAVITITE.getDefaultStack(), 1), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_LEGGINGS_GRAVITITE.getDefaultStack(), 1), 1.0);
        TREASURE = new WeightedRandomBag();
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_VAMPIRE.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_FLAME.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_PIG.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_BOW_PHOENIX.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_GLOVES_PHOENIX.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_BOOTS_PHOENIX.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_HELMET_PHOENIX.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_CHESTPLATE_PHOENIX.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_LEGGINGS_PHOENIX.getDefaultStack(), 1), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.LIFESHARD.getDefaultStack(), 1, 2), 50.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_DUNGEON_COMPASS.getDefaultStack()), 25.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.RECORD_NETHER.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_CAPE_INVISIBILITY.getDefaultStack()), 100.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_SHIELD_REPULSION.getDefaultStack()), 100.0);
    }
}

