/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import teamport.aether.helper.unboxed.IntPair;

public class MazeHelper {
    public static List<IntPair> randomMazeKruskal(Map<Integer, List<Integer>> graph, int size) {
        List<IntPair> edges = MazeHelper.makeEdgeList(graph);
        Collections.shuffle(edges);
        return MazeHelper.randomMazeKruskal(edges, size);
    }

    public static List<IntPair> randomMazeKruskal(List<IntPair> edges, int size) {
        ArrayList<IntPair> mst = new ArrayList<IntPair>();
        Dsu uf = new Dsu(size);
        for (IntPair edge : edges) {
            if (uf.union(edge.getFirst(), edge.getSecond())) {
                mst.add(edge);
            }
            if (mst.size() != size - 1) continue;
            break;
        }
        return mst;
    }

    public static List<IntPair> makeEdgeList(Map<Integer, List<Integer>> graph) {
        HashSet<IntPair> edgeSet = new HashSet<IntPair>();
        for (Map.Entry<Integer, List<Integer>> node : graph.entrySet()) {
            int currentNode = node.getKey();
            for (Integer next : node.getValue()) {
                int to = Math.min(next, currentNode);
                int from = Math.max(next, currentNode);
                edgeSet.add(new IntPair(to, from));
            }
        }
        return new ArrayList<IntPair>(edgeSet);
    }

    public static Map<Integer, List<Integer>> makeGraph(List<IntPair> edgeList) {
        HashMap<Integer, List<Integer>> graph = new HashMap<Integer, List<Integer>>();
        for (IntPair edge : edgeList) {
            Integer u = edge.getFirst();
            Integer v = edge.getSecond();
            graph.computeIfAbsent(u, k -> new ArrayList()).add(v);
            graph.computeIfAbsent(v, k -> new ArrayList()).add(u);
        }
        return graph;
    }

    public static class Dsu {
        int[] parent;
        int[] rank;

        public Dsu(int size) {
            this.parent = new int[size];
            this.rank = new int[size];
            for (int i = 0; i < size; ++i) {
                this.parent[i] = i;
            }
        }

        public int find(int a) {
            while (this.parent[a] != a) {
                this.parent[a] = this.parent[this.parent[a]];
                a = this.parent[a];
            }
            return a;
        }

        public boolean union(int x, int y) {
            int rootY;
            int rootX = this.find(x);
            if (rootX == (rootY = this.find(y))) {
                return false;
            }
            if (this.rank[rootX] < this.rank[rootY]) {
                int temp = rootX;
                rootX = rootY;
                rootY = temp;
            }
            this.parent[rootY] = rootX;
            if (this.rank[rootX] == this.rank[rootY]) {
                int n = rootX;
                this.rank[n] = this.rank[n] + 1;
            }
            return true;
        }
    }
}

