package teamport.aether.items.accessory.trinket;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import teamport.aether.items.accessory.IAccessoryEffects;
import teamport.aether.items.accessory.ItemTrinket;

import static teamport.aether.items.accessory.SlotAccessory.TRINKET_1_SLOT;

public class ItemIronBubble extends ItemTrinket implements IAccessoryEffects {
    public ItemIronBubble(String translationKey, String namespaceId, int id, String name) {
        super(translationKey, namespaceId, id, name);
    }

    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int slotId, boolean flag) {
        Player player = (Player) entity;
        if (
                slotId < player.inventory.mainInventory.length
                        || slotId - player.inventory.mainInventory.length < TRINKET_1_SLOT
        ) {
            return;
        }
        player.airSupply = 0;
    }

    public void removeEffect(Player player, ItemStack accessory) {
        player.airSupply = 300;
    }

}
