package teamport.aether.mixin.accessory.cape.invisibilitycape.target;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.entity.boss.EnemyBoss;
import teamport.aether.items.accessory.AetherInvisibility;

@Mixin(value = MobSpider.class, remap = false)
public class MobSpiderMixinInvisiblePlayer {

    @WrapOperation(method = "findPlayerToAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/core/world/World;getClosestPlayerToEntity(Lnet/minecraft/core/entity/Entity;D)Lnet/minecraft/core/entity/player/Player;"))
    public Player hardToSpotInvisPlayer(World instance, Entity entity, double radius, Operation<Player> original) {
        MobSpider asThis = (MobSpider) (Object) this;
        Player player = original.call(instance, entity, radius);
        if (player == null || !asThis.canEntityBeSeen(player) || !player.getGamemode().areMobsHostile()) {
            return null;
        }
        if (player instanceof AetherInvisibility && !(asThis instanceof EnemyBoss)) {
            AetherInvisibility invPlayer = (AetherInvisibility) player;
            if (invPlayer.aether$isInvisible()) {
                Player newPlayer = asThis.world.getClosestPlayerToEntity(asThis, 2.0);
                if (newPlayer == null || !asThis.canEntityBeSeen(newPlayer) || !newPlayer.getGamemode().areMobsHostile()) {
                    return null;
                }
                return newPlayer;
            }
        }
        return player;
    }
}
