/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.block.BlockLogicNote;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.entity.INetworkEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.biome.Biome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teamport.aether.AetherConfig;
import teamport.aether.blocks.AetherBlockDetails;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.effect.AetherEffects;
import teamport.aether.entity.AetherEntities;
import teamport.aether.items.AetherItems;
import teamport.aether.items.accessory.ItemTrinket;
import teamport.aether.net.NetEntryAetherProjectile;
import teamport.aether.net.NetEntryFloatingBlock;
import teamport.aether.net.NetEntryLightning;
import teamport.aether.net.NetEntryParachute;
import teamport.aether.net.NetEntrySlider;
import teamport.aether.net.message.AetherDungeonMapUpdateNetworkMessage;
import teamport.aether.net.message.AetherRideableNetworkMessage;
import teamport.aether.net.message.AetherSyncInvisibilityNetworkMessage;
import teamport.aether.net.message.BossListNetworkMessage;
import teamport.aether.net.message.SunspiritDeathNetworkMessage;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.biome.AetherBiomes;
import teamport.aether.world.feature.AetherWorldFeatures;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.util.GameStartEntrypoint;

public class AetherMod
implements GameStartEntrypoint,
ModInitializer {
    public static final String MOD_ID = "aether";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"aether");
    public static String versionString = ((ModContainer)FabricLoader.getInstance().getModContainer("aether").get()).getMetadata().getVersion().getFriendlyString();
    public static String state = "beta";
    public static I18n TRANSLATOR = null;
    public static MobFireflyCluster.FireflyColor SILVER;
    public static final DamageType LIGHTNING;
    public static final DamageType HOLY;
    public static final Map<Integer, BlockLogicNote.Instrument> BLOCK_INSTRUMENTS;
    public static final BlockLogicNote.Instrument FLUTE;
    public static final BlockLogicNote.Instrument CLICK;
    public static final BlockLogicNote.Instrument XYLOPHONE;
    public static final BlockLogicNote.Instrument BELL;
    public static final BlockLogicNote.Instrument TRUMPET;
    public static final BlockLogicNote.Instrument ORGAN;
    public static final BlockLogicNote.Instrument SITAR;
    public static final BlockLogicNote.Instrument TRANCE;
    public static final BlockLogicNote.Instrument SAXOPHONE;
    public static final BlockLogicNote.Instrument MUSICBOX;
    public static final byte ARMOR_START_INDEX = 41;
    public static final float ZANITE_MULTIPLIER = 2.0f;
    public static final byte BRONZE_CHANCES = 4;
    public static final byte SILVER_CHANCES = 10;
    public static final byte GOLD_CHANCES = 11;

    public void onInitialize() {
        LOGGER.info("Aether initialized, welcome to a hostile paradise. Version {} {}", (Object)state, (Object)versionString);
        NetworkHandler.registerNetworkMessage(SunspiritDeathNetworkMessage::new);
        NetworkHandler.registerNetworkMessage(AetherRideableNetworkMessage::new);
        NetworkHandler.registerNetworkMessage(BossListNetworkMessage::new);
        NetworkHandler.registerNetworkMessage(AetherDungeonMapUpdateNetworkMessage::new);
        NetworkHandler.registerNetworkMessage(AetherSyncInvisibilityNetworkMessage::new);
    }

    public void beforeGameStart() {
        AetherConfig.Setup();
        AetherEntities.init();
        AetherBlocks.init();
        AetherItems.init();
        AetherDimension.init();
        AetherWorldFeatures.init();
        SILVER = MobFireflyCluster.FireflyColor.register((MobFireflyCluster.FireflyColor)new MobFireflyCluster.FireflyColor(10, "fireflySilver", new Biome[]{AetherBiomes.AETHER_PLAINS}, new float[]{0.5f, 1.0f, 0.88f}));
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryLightning(), (int)32);
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryAetherProjectile(), (int)35);
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryParachute(), (int)36);
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryFloatingBlock(), (int)37);
        NetEntityHandler.registerNetworkEntry((INetworkEntry)new NetEntrySlider());
        SoundTypes.loadSoundsJson((String)MOD_ID);
    }

    public void afterGameStart() {
        AetherEffects.init();
        TRANSLATOR = I18n.getInstance();
        EntityPainting.addBorder((ItemStack)AetherItems.AMBER.getDefaultStack(), (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"border_amber"));
        EntityPainting.addBorder((ItemStack)AetherItems.ZANITE.getDefaultStack(), (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"border_zanite"));
        EntityPainting.addBorder((ItemStack)AetherBlocks.BLOCK_GRAVITITE.getDefaultStack(), (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"border_gravitite"));
        AetherBlockDetails.initializeBlockDetails();
        AetherMod.registerNewTagForItems();
    }

    public static void registerNewTagForItems() {
        ItemTrinket.setIcon(Items.TOOL_COMPASS, "aether:item/trinket/armor_compass_outline");
        ItemTrinket.setIcon(Items.TOOL_CALENDAR, "aether:item/trinket/armor_calendar_outline");
        ItemTrinket.setIcon(Items.TOOL_CLOCK, "aether:item/trinket/armor_clock_outline");
        ItemTrinket.setIcon((Item)Items.MAP, "aether:item/trinket/armor_map_outline");
        ItemTrinket.setIcon(AetherItems.TOOL_DUNGEON_COMPASS, "aether:item/trinket/armor_compass_outline");
        Blocks.WORKBENCH.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_AXE});
        Blocks.FURNACE_STONE_ACTIVE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.FURNACE_STONE_IDLE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.FURNACE_BLAST_ACTIVE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.FURNACE_BLAST_IDLE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.TROMMEL_ACTIVE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.TROMMEL_IDLE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.LADDER_OAK.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_AXE});
        Blocks.GLOWSTONE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.ICE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
        Blocks.PERMAICE.withTags(new Tag[]{AetherBlockTags.MINEABLE_BY_AETHER_PICKAXE});
    }

    static {
        LIGHTNING = new DamageType("damagetype.lightning", true, true, "aether:gui/hud/protection_lightning");
        HOLY = new DamageType("damagetype.holy", false, true, "aether:gui/hud/protection_holy");
        BLOCK_INSTRUMENTS = new HashMap<Integer, BlockLogicNote.Instrument>();
        FLUTE = new BlockLogicNote.Instrument(11, "flute");
        CLICK = new BlockLogicNote.Instrument(12, "click");
        XYLOPHONE = new BlockLogicNote.Instrument(13, "xylophone");
        BELL = new BlockLogicNote.Instrument(14, "bell");
        TRUMPET = new BlockLogicNote.Instrument(15, "trumpet");
        ORGAN = new BlockLogicNote.Instrument(16, "organ");
        SITAR = new BlockLogicNote.Instrument(17, "sitar");
        TRANCE = new BlockLogicNote.Instrument(18, "trance");
        SAXOPHONE = new BlockLogicNote.Instrument(19, "saxophone");
        MUSICBOX = new BlockLogicNote.Instrument(20, "musicbox");
    }
}

