/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.dungeon;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.blocks.dungeon.BlockLogicDungeon;
import teamport.aether.entity.monster.sentry.MobSentry;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicTrapped
extends BlockLogicDungeon {
    public final Class<? extends Entity> monster;
    public final Block<?> breakResult;
    public final Block<?> replaceOnClear;
    public final int CHANCE;

    public BlockLogicTrapped(Block<?> block, Block<?> breakResult, Block<?> replaceOnClear, Class<? extends Entity> monster, int CHANCE) {
        super(block, Material.stone);
        this.monster = monster;
        this.breakResult = breakResult;
        this.replaceOnClear = replaceOnClear;
        this.CHANCE = CHANCE > 0 ? CHANCE : 2;
    }

    public ItemStack @Nullable [] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return this.breakResult.getBreakResult(world, dropCause, meta, tileEntity);
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (EnvironmentHelper.isClientWorld()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (world.rand.nextInt(this.CHANCE) != 0) {
            return;
        }
        int tries = 16;
        while (tries-- > 0) {
            Entity monster;
            double spawnZ;
            double spawnY;
            double angleRad = Math.toRadians(world.rand.nextInt(360));
            float distance = (float)(2 + world.rand.nextInt(2)) - (float)world.rand.nextInt(11) / 10.0f;
            double spawnX = (double)x + 0.5 + (double)distance * Math.cos(angleRad);
            if (!BlockLogicTrapped.isSafe(world, spawnX, spawnY = (double)y + 1.25, spawnZ = (double)z + 0.5 + (double)distance * Math.sin(angleRad)) || (monster = EntityDispatcher.createEntityInWorld(this.monster, (World)world)) == null) continue;
            monster.spawnInit();
            monster.moveTo(spawnX, (double)(y + 1), spawnZ, 0.0f, 0.0f);
            world.entityJoinedWorld(monster);
            this.spawnDecorations(world, x, y, z, spawnX, spawnY, spawnZ, entity, monster);
            if (monster instanceof MobSentry) {
                ((Player)entity).triggerAchievement((Stat)AetherAchievements.SENTRY_DEPLOYED);
            }
            return;
        }
    }

    private void spawnDecorations(World world, int x, int y, int z, double spawnX, double spawnY, double spawnZ, Entity player, Entity monster) {
        for (int l = 0; l < 8; ++l) {
            double angle = Math.toRadians(l * 45);
            ParticleMaker.spawnParticle(world, "snowshovel", spawnX, spawnY, spawnZ, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
            ParticleMaker.spawnParticle(world, "snowshovel", spawnX, spawnY, spawnZ, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
            ParticleMaker.spawnParticle(world, "largesmoke", spawnX, spawnY, spawnZ, -Math.cos(angle) / 15.0, 0.03, -Math.sin(angle) / 15.0, 0);
        }
        world.playSoundEffect(player, SoundCategory.ENTITY_SOUNDS, (double)x, (double)y, (double)z, "mob.ghast.fireball", 1.0f, 1.0f);
        world.playSoundAtEntity(player, monster, "mob.ghast.fireball", 0.25f, 0.75f);
    }

    private static boolean isSafe(World world, double x, double y, double z) {
        int iz;
        int iy;
        int ix = (int)Math.round(x);
        return !world.isBlockNormalCube(ix, iy = (int)Math.round(y), iz = (int)Math.round(z)) && !world.isBlockNormalCube(ix, iy + 1, iz);
    }
}

